/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int STkeyMatch (const char String[], const char *KeyTable[])

Purpose:
  Match a string to keyword strings

Description:
  This subroutine searches a table for a match to a character string.  The
  table of keywords is searched for the first match.  The keyword table can
  optionally specify the minimum length for a match and a length beyond which
  characters need no longer match.

  Each entry of the keyword table specifies the character string to be matched.
  An optional asterisk ('*') is used to indicate the minimum number of
  characters needed for a match.  A second asterisk can be used to indicate
  that characters in the input string after this point need not match.
  Example: Keyword table entry "abc*de*f".
    - Input strings "abc", "abcd", "abcde", and "abcdex" will match this entry.
    - Input strings "ab", "abC" " abc" and "abcx" do not match this entry.

Parameters:
  <-  int
  STkeyMatch -	Index of the matched keyword.  This value is set to -1 if no
		match is found.
		-1 - No match
		 0 - Match to the first keyword
		 1 - Match to the second keyword
		 ...

  ->  const char []
  string -	Input character string
  ->  const char * []
  KeyTable -	Pointer array with pointers to the keyword strings.  The end of
		the keyword table is signalled with a NULL pointer.  Note that
		with ANSI C, if KeyTable is not declared to have the const
		attribute, an explicit cast to (const char **) is required.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.8 $  $Date: 1994/02/03 02:55:16 $

-------------------------------------------------------------------------*/

static char rcsid []="$Id: STkeyMatch.c 1.8 1994/02/03 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))

int
STkeyMatch (String, KeyTable)

     const char String[];
     const char *KeyTable [];

{

  int i;
  const char *kt;
  int nf;
  int nt;
  char *fstar;
  char *lstar;
  int lens;

  for (i = 0; KeyTable[i] != NULL; ++i) {
    /*
       Find the positions of the *'s in the keyword; fstar points to the
       first *, lstar points to the second *
    */
    kt = KeyTable[i];
    fstar = strchr (kt, '*');

/* Check for a match */
/* String matches are made only for strings with valid lengths */
    if (fstar == NULL) {
      /* No asterisks in the keyword string, need an exact match */
      if (strcmp (String, kt) == 0)
	return i;
    }
    else {

      nf = fstar - kt;
      lens = strlen (String);
      nt = lens - nf;
      lstar = strchr (fstar+1, '*');
      if (lstar != NULL)
	nt = MINV (nt, (lstar - fstar) - 1);
      /*
	 We want to match nf characters in the first part.  We want to
	 match min (lens-nf, lstar-fstar-1) characters in the second part.
      */
      if (lens >= nf && strncmp (String, kt, nf) == 0
	             && strncmp (String+nf, fstar+1, nt) == 0)
	return i;
    }
  }
  return -1;
}
