/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int STdecRange (const char String[], int *Ival1, int *Ival2)

Purpose:
  Decode a range specification for integer values

Description:
  This routine decodes a string giving a range of integer values.  The range
  is specified in the form "Iv" or "Iv1:Iv2", for example "-23 : 45".
  Optional white-space (as defined by isspace) can surround the integer values.
  For the first case of a single value, this is equivalent to the range
  "Iv:Iv".

Parameters:
  <-  int
  STdecRange -	Error status, 0 for no error, 1 for error
  ->  const char []
  String -	Input string
  <-  int *
  Ival1 -	First integer value
  <-  int *
  Ival2 -	Second integer value

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.8 $  $Date: 1994/02/11 14:31:46 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecRange.c 1.8 1994/02/11 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

int
STdecRange (String, Ival1, Ival2)

     const char String[];
     int *Ival1;
     int *Ival2;

{

  char *token;
  int nc;
  const char *p;
  int status;

/* Allocate temporary string space */
  nc = strlen (String);
  token = (char *) UTmalloc (nc + 1);

/* Decode the first part of the range */
  p = STfindToken (String, ":", "", token, 1, nc);
  status = STdecInt1 (token, Ival1);
  if (status != 0)
    return status;

/* Decode the second part of the range */
  if (p != NULL) {
    p = STfindToken (p, ":", "", token, 1, nc);
    status = STdecInt1 (token, Ival2);
    if (status != 0)
      return status;

    /* Check for extra data */
    if (p != NULL)
      UTwarn ("STdecRange: Extra data ignored");
  }

  else
    *Ival2 = *Ival1;

  UTfree (token);
  return status;
}
