/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int STdecInt1 (const char String[], int *Ival)

Purpose:
  Decode an integer value

Description:
  This routine decodes a string containing a numeric value.  The decoded data
  is stored as an integer value.  If a decoding error is detected, a warning
  message is printed and an error status value is returned.  A warning message
  is printed if extra data follows the requested value (this data is ignored).

Parameters:
  <-  int
  STdecInt1 -	Error status, 0 for no error, 1 for error
  ->  const char []
  String -	Input string
  <-  int *
  Ival -	Integer value.  This value is not changed if an error status is
		returned.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/01/19 23:20:37 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecInt1.c 1.3 1994/01/19 AFsp-V1R2 $";

#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

int
STdecInt1 (String, Ival)

     const char String[];
     int *Ival;

{
  int N;
  int Iv;
  int status;

  status = STdecInts (String,  1, 1, &Iv, &N);
  if (status == 0)
    *Ival = Iv;

  return status;
}
