/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int STdecFloats (const char String[], int Nmin, int Nmax, float Fval[Nmax],
		   int *N)

Purpose:
  Decode float values (variable number)

Description:
  This routine decodes a string containing numeric data.  Multiple data items
  data items in the string are separated by commas or white-space (as defined
  by the sscanf routine).  The decoded data is stored as float values.  If the
  number of data values in the string is less than a given minimum number or a
  decoding error is detected, an error message is printed and an error
  indication is returned.  A warning messages is printed if extra data follows
  the requested values (this data is ignored).

Parameters:
  <- int
  STdecInts -	Returned value,
		0 - no error
		1 - error.  Too few values or data format error.
  ->  const char []
  String -	Input string
  ->  int
  Nmin -	Minimum number of values to be read (may be zero)
  ->  int
  Nmax -	Maximum number of values to be read
  <-  float []
  Fval -	Float array of MAXN elements used to store the decoded values.
  		Only the first N values are modified.
  <-  int *
  N -		Actual number of values decoded.  In the case of an error, N
		indicates the number of values successfully decoded.  In that
		case, N may be less than Nmin.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.6 $  $Date: 1994/02/16 04:38:33 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecFloats.c 1.6 1994/02/16 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

int
STdecFloats (String, Nmin, Nmax, Fval, N)

     const char String[];
     int Nmin;
     int Nmax;
     float Fval[];
     int *N;

{

  char *token;
  int nc;
  int n;
  const char *p;
  int m;
  int status;
  float fv;
  char c;

/* Allocate temporary string space */
  nc = strlen (String);
  token = (char *) UTmalloc (nc + 1);

/* Find the substrings */
  p = String;
  n = 0;
  status = 0;
  while	 (p != NULL && n < Nmax) {
    p = STfindToken (p, ",", "", token, 2, nc);
    if (token[0] != '\0') {
      /* Non-null token string */
      m = sscanf (token, "%g%c", &fv, &c);
      if (m != 1) {
	status = 1;
	if (strlen (token) > (unsigned) 23)
	  UTwarn ("STdecFloats: Data format error, data: \"%.20s...\"", token);
	else
	  UTwarn ("STdecFloats: Data format error, data \"%s\"", token);
	break;
      }
      Fval[n] = fv;
      ++n;
    }
    else {
      /* Null token string */
      if (p != NULL || n != 0 || Nmin != 0) {
	status = 1;
	UTwarn ("STdecFloats: Empty data string");
      }
      break;
    }
  }

/* Check the number of values found */
  if (status == 0) {
    if (n < Nmin) {
      status = 1;
      UTwarn ("STdecFloats: Too few data values");
    }
    if (p != NULL && n >= Nmax)
      UTwarn ("STdecFloats: Extra data ignored");
  }

  UTfree (token);
  *N = n;
  return status;
}
