/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int STdecFloat1 (const char String[], float *Fval)

Purpose:
  Decode a float value

Description:
  This routine decodes a string containing a numeric value.  The decoded datum
  is stored as a float value.  If a decoding error is detected, a warning
  message is printed and error status is set.  A warning messages is printed
  if extra data follows the requested value (this data is ignored).

Parameters:
  <-  int
  STdecInt1 -	Error status, 0 for no error, 1 for error
  ->  const char []
  String -	Input string
  <-  float *
  Fval -	Float value.  This value is not changed if an error status is
		returned.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/01/19 23:18:24 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecFloat1.c 1.3 1994/01/19 AFsp-V1R2 $";

#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

int
STdecFloat1 (String, Fval)

     const char String[];
     float *Fval;

{
  int N;
  float Fv;
  int status;

  status = STdecFloats (String,  1, 1, &Fv, &N);
  if (status == 0)
    *Fval = Fv;

  return status;
}
