/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void STcopyNMax (const char Si[], char So[], int N, int Maxchar)

Purpose:
  Copy N characters characters to a string

Description:
  This routine is used to copy min(N,Maxchar) characters from the input string
  to the output string.  A null character in the input string also terminates
  the transfer at that point.  If N is larger than Maxchar, a string truncated
  warning message is printed.

Parameters:
  ->  const char []
  Si -		Input character string
  <-  char []
  So -		Output character string.  This string is always null
		terminated, with at most Maxchar characters not including the
		terminating null character.  If the input string is longer than
		Maxchar, only the first Maxchar characters are copied and a
		warning message is printed.
  ->  size_t
  N -		Number of characters to be transferred
  ->  size_t
  Maxchar - 	Maximum number of characters (not including the terminating
		null character) to be placed in So.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.9 $  $Date: 1994/02/16 04:37:56 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STcopyNMax.c 1.9 1994/02/16 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))

void
STcopyNMax (Si, So, N, Maxchar)

     const char Si[];
     char So[];
     size_t N;
     size_t Maxchar;

{
  const char *si;
  char *so;
  int i;
  int NM;

  /* Save the initial pointers */
  si = Si;
  so = So;

  /* Copy at most Maxchar characters */
  NM = MINV (Maxchar, N);
  for (i = 0; i < NM && *si != '\0'; i++)
    *so++ = *si++;

  /* Add a trailing null */
  *so = '\0';

  /* Check for truncation */
  if (N > Maxchar && i == NM && Si[NM-1] != '\0') {
    if (strlen (Si) > (unsigned) 23)
      UTwarn ("STcopyNMax: String truncated, string: \"%.20s...\"", Si);
    else
      UTwarn ("STcopyNMaX: String truncated, string: \"%s\"", Si);
  }
}
