/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void STcopyMax (const char Si[], char So[], int Maxchar)

Purpose:
  Copy at most Maxchar characters to a string

Description:
  This routine copies characters from the input string to the output string.
  Characters are copied until a null is seen in the input string or the number
  of characters copied is Maxchar.  Then a trailing null character is appended
  to the output string.  If the input string is longer than Maxchar (not
  including the null character), a string truncated warning message is printed.

Parameters:
  ->  const char []
  Si -		Input character string
  <-  char []
  So -		Output character string.  This string is always null
		terminated, with at most Maxchar characters not including the
		terminating null character.  If the input string is longer than
		Maxchar, only the first Maxchar characters are copied and a
		warning message is printed.
  ->  size_t
  Maxchar - 	Maximum number of characters (not including the trailing null
		character) to be placed in So.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.9 $  $Date: 1994/02/16 04:37:28 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STcopyMax.c 1.9 1994/02/16 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

void
STcopyMax (Si, So, Maxchar)

     const char Si[];
     char So[];
     size_t Maxchar;

{
  const char *si;
  char *so;
  int i;

  /* Save the initial pointers */
  si = Si;
  so = So;

  /* Copy at most Maxchar characters */
  for (i = 0; i < Maxchar && *si != '\0'; i++)
    *so++ = *si++;

  /* Add a trailing null */
  *so = '\0';

  /* Check for truncation */
  if (*si != '\0') {
    if (strlen (Si) > (unsigned) 23)
      UTwarn ("STcopyMax: String truncated, string: \"%.20s...\"", Si);
    else
      UTwarn ("STcopyMax: String truncated, string: \"%s\"", Si);
  }
}
