/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void STcatMax (const char Si[], char So[], int Maxchar)

Purpose:
  Concatenate at most N characters to a string

Description:
  This routine appends characters from the input string to the end of the
  second string.  Characters are appended until a null is seen in the input
  string or the number of characters in the second string is Maxchar.  Then a
  trailing null character is appended to the output string.  If not all
  characters from the input string can be copied into the output string, a
  string truncated warning message is printed.

Parameters:
  ->  const char []
  Si -		Input character string to be appended to So
  <-> char []
  So -		Output character string.  This string is always null
		terminated, with at most Maxchar characters not including the
		terminating null character.  If the sum of the input string
		lengths is more than Maxchar, only the first Maxchar characters
		are output and a warning message is printed.
  ->  size_t
  Maxchar - 	Maximum number of characters (including the trailing null
		character) for So.  Note that So may be longer than Maxchar if
		it is so before calling this routine.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.10 $  $Date: 1994/02/16 04:36:18 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STcatMax.c 1.10 1994/02/16 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

void
STcatMax (Si, So, Maxchar)

     const char Si[];
     char So[];
     size_t Maxchar;

{
  const char *si;
  char *so;
  int i;

  /* Save the initial pointers */
  si = Si;
  so = So;

  /* Find the end of So */
  for (i = 0; i < Maxchar && *so != '\0'; i++)
    so++;

  /* Check for the possibility that So is already at its maximum length */
  if (i < Maxchar-1 || *so == '\0') {
    /* Copy to So for a length of at most Maxchar-1 characters */
    for (; i < Maxchar && *si != '\0'; i++)
      *so++ = *si++;

    /* Add a trailing null */
    *so = '\0';
  }

  /* Check for truncation */
  if (*si != '\0') {
    if (strlen (Si) > (unsigned) 23)
      UTwarn ("STcatMax: String truncated, string: \"%.20s...\"", Si);
    else
      UTwarn ("STcatMax: String truncated, string: \"%s\"", Si);
  }
}
