/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int SPquant (const float *x, const float Xq[], int Nlev]

Purpose:
  Binary search for a bounding interval

Description:
  This function returns the index of the quantizer region corresponding to a
  given input value.  The quantizer is specified by an array of quantizer
  decision levels.  A binary search is used to determine the quantizer region.

  The index value takes on values from 0 to Nlev-1.  If Nlev is equal to one,
  the index is set to zero.  Otherwise, the index is determined as follows,
    index            input value
     0                    x <= Xq[0]
     1            Xq[0] < x <= Xq[1]
     2            Xq[1] < x <= Xq[2]
    ...                  ...
     i          Xq[i-1] < x <= Xq[i]
    ...                  ...
   Nlev-2    Xq[Nlev-3] < x <= Xq[Nlev-2]
   Nlev-1    Xq[Nlev-2] < x

Parameters:
  <-  int
  SPquant -	Output index of the quantizer region containing the input
		value x.  SPquant takes on values from 0 to Nlev-1.
  ->  const float *
  x -		Value to be quantized
  ->  const float []
  Xq -		Array of Nlev-1 quantizer decision levels which delimit the
		Nlev quantizer regions.  These levels must be in ascending
                order.
  ->  int
  Nlev -	Number of quantizer regions

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/01/29 22:08:54 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: SPquant.c 1.3 1994/01/29 AFsp-V1R2 $";

#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

int
SPquant (x, Xq, Nlev)

     const float *x;
     const float Xq[];
     int Nlev;

{
  int iL;
  int iU;
  int i;

/* Binary search for the interval (Xq[iL], Xq[iU]] which brackets x */
  iL = 0;
  iU = Nlev;

  /* Isolate the interval */
  while (iU > iL + 1) {
    i = (iL + iU) / 2;
    if (*x <= Xq[i-1])
      iU = i;
    else
      iL = i;
  }

/* Return the index */
  return iL;
}
