/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int MSiFloor (int n, int m)

Purpose:
  Floor function for the ratio of two integers

Description:
  This routine calculates the floor function of the ratio m/n.  It returns the
  smallest integer that is less than or equal to the quotient.

Parameters:
  <-  int
  MSiFloor -	Returned integer value
  ->  int
  n -		Input value (numerator)
  ->  int
  m -		Input value (denominator)

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.1 $  $Date: 1994/02/01 02:39:13 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: MSiFloor.c 1.1 1994/02/01 AFsp-V1R2 $";

#include <libtsp.h>

int
MSiFloor (n, m)

     int n;
     int m;

{
/*
   The goal is to compute the floor function without intermediate overflows.
   Note that we cannot negate all negative values, since in twos complement
   negation of the largest magnitude negative number will give a positive value
   which is too large.

   Integer division gives the floor function for a positive result and the
   ceiling function for a negative result.  For a positive result, the floor
   function can be calculated with simple integer division.  This covers the
   case for n and m of the same sign.

   For integer n and m, and m > 0 floor[n/m] = ceil[(n+1)/m]-1.  If n is
   negative, this form can be expressed as an integer division int[(n+1)/m]-1.
   For n positive and m < 0, negating both n and m gives int[(-n+1)/(-m)]-1.
   To avoid the negation of m which could possibly overflow, this can be
   rewritten as int[(n-1)/m]-1.

   (1) n > 0 && m > 0 ==> int[n/m]
   (2) n < 0 && m < 0 ==> int[n/m]
   (1) n < 0 && m > 0 ==> int[(n+1)/m] + 1
   (2) n > 0 && m < 0 ==> int[(1-n)/m] + 1
   (5) n == 0         ==> int[n/m]

   The remaining (unavoidable) problems are
   - n = 0 and m = 0, gives an indeterminate answer
   - n != 0, m = 0, gives a divide by zero
*/
  if (m >= 0) {
    if (n >= 0)
      return (n / m);
    else
      return (((n + 1) / m) - 1);
  }
  else {
    if (n > 0)
      return (((n - 1) / m) - 1);
    else
      return (n / m);
  }
}
