/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int MSiCeil (int n, int m)

Purpose:
  Ceiling function for the ratio of two integers

Description:
  This routine calculates the ceiling function of the ratio m/n.  It returns
  the smallest integer that is greater than or equal to the quotient.

Parameters:
  <-  int
  MSiCeil -	Returned integer value
  ->  int
  n -		Input value (numerator)
  ->  int
  m -		Input value (denominator)

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.4 $  $Date: 1994/02/01 02:38:15 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: MSiCeil.c 1.4 1994/02/01 AFsp-V1R2 $";

#include <libtsp.h>

int
MSiCeil (n, m)

     int n;
     int m;

{
/*
   The goal is to compute the ceiling function without intermediate overflows.
   Note that we cannot negate all negative values, since in twos complement
   negation of the largest magnitude negative number will give a positive value
   which is too large.

   Integer division gives the floor function for a positive result and the
   ceiling function for a negative result.  For a negative result, the
   ceiling function can be calculated with simple integer division.  This
   covers the case for n and m of different signs.

   For integer n and m, and m > 0, ceil[n/m] = floor[(n-1)/m]+1.  If both n
   and m are positive, this form can be expressed as an integer division,
   int[(n-1)/m]+1.  For n and m both negative, negating both n and m gives
   int[(-n-1)/(-m)]+1.  To avoid the negation of m which could possibly
   overflow, this can be rewritten as int[(n+1)/m]+1.

   (1) n > 0 && m > 0 ==> int[(n-1)/m] + 1
   (2) n < 0 && m < 0 ==> int[(n+1)/m] + 1
   (3) n > 0 && m < 0 ==> int[n/m]
   (4) n < 0 && m > 0 ==> int[n/m]
   (5) n == 0         ==> int[n/m]

   The remaining (unavoidable) problems are
   - n = 0 and m = 0, gives an indeterminate answer
   - n != 0, m = 0, gives a divide by zero
   - n = INT_MIN and m = -1, gives an overflow for twos complement arithmetic
*/
  if (m >= 0) {
    if (n > 0)
      return (((n - 1) / m) + 1);
    else
      return (n / m);
  }
  else {
    if (n >= 0)
      return (n / m);
    else
      return (((n + 1) / m) + 1);
  }
}
