/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Module:
  void FLjoinNames (const char Dname[], const char Bname[], char Fname[])

Purpose:
  Form a file name from a directory path and a base name

Description:
  This routine takes an input file path and appends file name components to
  form a file name string.  This routine can be used to form a name from a
  directory string and a file name string.  It joins these components together
  separated by a '/' character.  However, the '/' character is omitted if
  either input part is empty or if the directory part already ends in a '/'.
  The operations are arranged so that the output file name can overlay either
  of the input strings.

Parameters:
  ->  const char []
  Dname -	Input character string with the path name
  ->  const char []
  Bname -	input character string with the base name of the file
  <-  char []
  Fname -	Output string formed by joining the two input strings.  This
		string is at most FILENAME_MAX characters long not including
		the terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.2 $  $Date: 1994/02/16 23:53:10 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLjoinNames.c 1.2 1994/02/16 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>
#include <libtsp/FLnucleus.h>

#ifndef __STDC__
#define	const
#endif

void
FLjoinNames (Dname, Bname, Fname)

     const char Dname[];
     const char Bname[];
     char Fname[];

{
  char tname[FILENAME_MAX+1];
  int n;

  /* Form the name in temporary storage */
  n = strlen (Dname);
  STcopyMax (Dname, tname, FILENAME_MAX);
  if (n > 0 && Bname[0] != '\0' && Dname[n-1] != '/')
    STcatMax ("/", tname, FILENAME_MAX);
  STcatMax (Bname, tname, FILENAME_MAX);

  /* Copy the final name to the output name */
  STcopyMax (tname, Fname, FILENAME_MAX);
}
