/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Module:
  void FLhomeDir (const char User[], char Home[])

Purpose:
  Get the home directory for a user

Description:
  This routine returns the path name corresponding to the home directory for a
  user.  When the argument is empty, the current user is assumed.  In that
  case, the translation of the environment variable HOME is used if possible.
  In other cases, the home directory is taken from the password entry for the
  user.  If the user is unknown, the home directory string is returned as
  "~User".

Parameters:
  ->  const char []
  User -	Input character string specifying the user.  If this string is
		empty, the current user is used.
  <-  char []
  Home -	Output string with the home directory.  Except for the case of
  		the root directory "/", the directory name does not have a
		trailing '/' character.  This string is at most FILENAME_MAX
		characters long not including the terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.6 $  $Date: 1994/01/24 22:08:10 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLhomeDir.c 1.6 1994/01/24 AFsp-V1R2 $";

#include <stdlib.h>	/* getenv prototype */
#include <pwd.h>	/* struct passwd, getpwnam prototype */
#include <unistd.h>	/* getuid definitions */
#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

void
FLhomeDir (User, Home)

     const char User[];
     char Home[];

{
  char *h;
  struct passwd *pwd;
  int n;

  if (User[0] == '\0') {

    /* No user name specified, get directory from environment HOME */
    h = getenv ("HOME");
    if (h != NULL && *h != '\0') {
      n = strlen (h);
      if (n > 1 && h[n-1] == '/')
	--n;
      STcopyNMax (h, Home, n, FILENAME_MAX);
    }
  }
  else {
    /* Find the password entry */
    if (User[0] == '\0')
      pwd = getpwuid (getuid ());
    else
      pwd = getpwnam (User);

    /* Get the home directory from the password entry  */
    if (pwd != NULL) {
      n = strlen (pwd->pw_dir);
      if (n > 1 && pwd->pw_dir[n-1] == '/')
	--n;
      STcopyNMax (pwd->pw_dir, Home, n, FILENAME_MAX);
    }
    else {
      /* Unsuccessful, probably because of Unknown User */
      STcopyMax ("~", Home, FILENAME_MAX);
      STcatMax (User, Home, FILENAME_MAX);
    }
  }
}
