/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Module:
  char *FLfileDate (FILE *fp, int format)

Purpose:
  Find the last modification time for an open file

Description:
  This routine finds the last modified time for a file specified by the file
  pointer to an open file.  This time is returned as a date/time string in one
  of a number of standard formats.

  Format  Example                       time zone    length
    0    Sun Sep 16 01:03:52 1973      local time   24 characters + null
    1    Sun Sep 16 01:03:52 EST 1973  local time   28* characters + null
    2    1994/01/23 09:59:53 EST       local time   23* characters + null
    3    1994/01/23 14:59:53 UTC       GMT          23 characters + null
              (*) the time zone length can vary

Parameters:
  <-  char *
  FLfileDate -	Pointer to a character string for the date and time.  This
		string is null terminated.  This string is at most 29
		characters long, not including the terminating null character.
		This is a pointer to an internal static storage area; each call
		to this routine overlays this storage.
  ->  FILE *
  fp -		File pointer for the file
  ->  int
  format -	Date / time format code, taking on values from 0 to 3

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.2 $  $Date: 1994/02/23 23:58:17 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLfileDate.c 1.2 1994/02/23 AFsp-V1R2 $";

#include <sys/types.h>
#include <sys/stat.h>
#include <libtsp.h>
#include <libtsp/UTnucleus.h>

#ifndef __STDC__
#define	const
#endif

#define MXDATE	29

char *
FLfileDate (fp, format)

     FILE *fp;
     int format;

{
  struct stat Fstat;
  int fd;
  int status;
  static char Datetime[MXDATE+1];

  status = fstat (fileno (fp), &Fstat);
  if (status == 0)
    STcopyMax (UTctime (&Fstat.st_mtime, format), Datetime, MXDATE);
  else
    Datetime[0] = '\0';

  return Datetime;
}
