/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Module:
  void FLexpHome (const char Fname[], char Ename[])

Purpose:
  Expand the home directory specification for a file

Description:
  This routine takes an input file name and replaces instances of "~" or
  "~USER" which appear as the first component of a directory specification.
  The first form is replaced by the home directory of the current user and the
  second form is replaced by the home directory of the named user.  If the home
  directory cannot be determined, for instance if the user is unknown, the
  output file name is just copied from the input file name.

Parameters:
  ->  const char []
  Fname -	Input character string specifying a file name path
  <-  char []
  Ename -	Output string with the home directory expanded.  This string is
		at most FILENAME_MAX characters long not including the
		terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.4 $  $Date: 1994/02/17 00:16:34 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLexpHome.c 1.4 1994/02/17 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>
#include <libtsp/FLnucleus.h>

#ifndef __STDC__
#define	const
#endif

void
FLexpHome (Fname, Ename)

     const char Fname[];
     char Ename[];

{
  char *p;
  char User[FILENAME_MAX+1];
  char Home[FILENAME_MAX+1];

  if (Fname[0] == '~') {

    /* Isolate the user name */
    p = strchr (Fname, '/');
    if (p == NULL)
      STcopyMax (&Fname[1], User, FILENAME_MAX);
    else
      STcopyNMax (&Fname[1], User, (p - Fname) - 1, FILENAME_MAX);

    /* Find the home directory */
    FLhomeDir (User, Home);

    /* If no home directory found, just return the name */
    if (Home[0] == '~') {
      STcopyMax (Fname, Ename, FILENAME_MAX);
      return;
    }

    /* Form the output name */
    if (p == NULL)
      STcopyMax (Home, Ename, FILENAME_MAX);
    else
      FLjoinNames (Home, p + 1, Ename);
  }

  else
    /* No ~ */
    STcopyMax (Fname, Ename, FILENAME_MAX);
}
