/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Module:
  void FLdirName (const char Fname[], char Bname[])

Purpose:
  Return all but the last component of a file path

Description:
  This routine takes a file path specification and returns all but the right-
  most component of the file name.  Components are separated by "/" characters.
  If no "/" character appears in the name, the name "." is returned.

  Examples:
     "abc/def"      => "abc"
     "abc/bcd/def"  => "abc/bcd"
     "/abc/def"     => "/abc"
     "/abc/bcd/def" => "/abc/bcd"
     "./def"        => "."
     "def"          => ""
  Special cases:
     "/def"         => "/"
     "/"            => "/"

Parameters:
  -> const char []
  Fname -	Input character string with the path name
  <- char []
  Bname -	Output string with the all but the last path name component.
                This string at most FILENAME_MAX characters long not including
		the terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.6 $  $Date: 1994/01/24 22:06:48 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLdirName.c 1.6 1994/01/24 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

void
FLdirName (Fname, Dname)

     const char Fname[];
     char Dname[];

{
  char *p;
  int N;

/* Break the string at the last "/" */
  p = strrchr (Fname, '/');
  if (p != NULL) {
    N = p - Fname;
    if (N == 0)
      STcopyMax ("/", Dname, FILENAME_MAX);
    else
      STcopyNMax (Fname, Dname, N, FILENAME_MAX);
  }
  else
    STcopyMax ("", Dname, FILENAME_MAX);

}
