/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Module:
  void FLbaseName (const char Fname[], char Bname[])

Purpose:
  Return the last component of a file path

Description:
  This routine takes a file path specification and returns the rightmost
  component.  Components are separated by "/" characters.  If no "/" character
  appears in the name, the full name is returned, even if of zero length.

Parameters:
  -> const char []
  Fname -	Input character string with the path name
  <- char []
  Bname -	Output string with the last path name component.  This string
		is at most FILENAME_MAX characters long not including the
		terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/01/24 22:04:33 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLbaseName.c 1.5 1994/01/24 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

void
FLbaseName (Fname, Bname)

     const char Fname[];
     char Bname[];

{
  char *p;

  p = strrchr (Fname, '/');
  if (p != NULL)
    STcopyMax (p+1, Bname, FILENAME_MAX);
  else
    STcopyMax (Fname, Bname, FILENAME_MAX);
}
