/*------------ Telecommunications & Signal Processing Lab -------------
                         McGill University

Module:
  void FLbackup (const char Fname[])

Purpose:
   Rename an existing file

Description:
  This subroutine backs up a file.  If a file with the given name exists, say
  xxx, that file is renamed to xxx~.  Any previous file with the name xxx~ is
  removed.  Files corresponding to terminals are not backed up.  If a backup
  file is created, a warning message indicating the new name is issued.

  One use of this routine is to backup files before opening a new file.

Parameters:
  ->  const char []
  Fname -	File name


Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/01/27 04:55:43 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLbackup.c 1.5 1994/01/27 AFsp-V1R2 $";

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

void
FLbackup (Fname)

     const char Fname[];

{
  char Ftemp[FILENAME_MAX+1];
  struct stat Fstat;
  int status;
  int n;

  /* Rename only if the file is a regular file */  
  status = stat (Fname, &Fstat);
  if (status == 0 && (Fstat.st_mode & S_IFREG) != 0) {
    n = strlen (Fname);
    if (n < FILENAME_MAX) {
      strcpy (Ftemp, Fname);
      Ftemp[n] = '~';
      Ftemp[n+1] = '\0';
      status = rename (Fname, Ftemp);
      if (status == 0)
	UTwarn ("FLbackup: Renamed existing file to %s", Ftemp);
    }
  }
}
