/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int ARfSymArray (const float x[], int N)

Purpose:
  Determine if an array of floats is symmetric or anti-symmetric

Description:
  This procedure returns a value which indicates whether a given array of float
  values is symmetric, anti-symmetric or neither.  A symmetric array has values
  which satisfy,
    x[i] = x[N-i-1], for i = 0, 1, ..., N-1.
  An anti-symmetric array has values which satisfy,
    x[i] = -x[N-i-1], for i = 0, 1, ..., N-1.
  An all-zero array will be declared to be symmetric.

Parameters:
  <-  int
  ARfSymArray -	integer value
		+1, if x[i] =  x[N-i-1], for i = 0, 1, ..., N-1
                -1, if x[i] = -x[N-i-1], for i = 0, 1, ..., N-1
                 0, otherwise
  ->  const float []
  x -		Array of floats with N elements
  ->  int
  N -		Number of elements in the input array

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.2 $  $Date: 1994/02/02 13:23:47 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: ARfSymArray.c 1.2 1994/02/02 AFsp-V1R2 $";

#include <libtsp.h>

#ifndef __STDC__
#define	const
#endif

int
ARfSymArray (x, N)

     const float x[];
     int N;

{
  int i;
  int j;

/* Check for symmetry, no need to check the middle point */
  for (i = 0, j = N - 1; i < j; ++i, --j) {
    if (x[i] != x[j])
      break;
  }
  if (i >= j)
    return 1;

/* Check for anti-symmetry, check for middle point (must be zero) */
  for (i = 0, j = N - 1; i <= j; ++i, --j) {
    if (x[i] != -x[j])
      break;
  }
  if (i > j)
    return -1;

/* Otherwise */
  return 0;

}
