/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void ARfShift (float x[], int Nkeep, int Nshift)

Purpose:
  Shift the elements of an array of floats

Description:
  This routine shifts elements fo a float array.  If the number of elements to
  be retained is zero, no action is taken.  For a shift down (Nshift positive),
  the elements of the array are shifted down to the bottom of the array.  The
  input array must have at least Nkeep + Nshift elements.
    x[i+Nshift] --> x[i], for i from 1 to Nkeep
  For a shift up (NSHIFT negative), the elements of the array are shifted up to
  the top of the array.  The input array must have at least Nkeep - Nshift
  elements (Nshift being negative).
    x[i] --> x[i-Nshift], for i from Nkeep to 1

Parameters:
  <->  float []
  x -		Array of floats (Nkeep + |Nshift| elements
  ->  int
  Nkeep -	Number of elements to be retained
  ->  int
  Nshift -	Number of positions to be shifted.  Nshift is positive for a
		shift down and negative for a shift up.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.2 $  $Date: 1994/02/04 21:18:09 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: ARfShift.c 1.2 1994/02/04 AFsp-V1R2 $";

#include <libtsp.h>

void
ARfShift (x, Nkeep, Nshift)

     float x[];
     int Nkeep;
     int Nshift;

{
  int i;

  if (Nshift > 0) {
    /* Shift down */
    for (i = 0; i < Nkeep; ++i) {
      x[i] = x[i+Nshift];
    }
  }
  else if (Nshift < 0) {
    /* Shift down */
    for (i = Nkeep - 1; i >= 0; --i) {
      x[i-Nshift] = x[i];	/* Looks funny but recall Nshift < 0 */
    }
  }
}
