/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void AFwriteI2 (FILE *fp, float Fbuff[], int Nval)

Purpose:
  Write 32-bit integer data to an audio file (float input values)

Description:
  This routine writes a specified number of 16-bit integer samples to an audio
  file.  The input to this routine is a buffer of float values. The file must
  have been opened using subroutine AFopenWrite.

Parameters:
  ->  FILE *
  fp -		File pointer for a file opened by AFopenWrite
  ->  float []
  Fbuff -	Array of floats with the samples to be written
  ->  int
  Nval -	Number of samples to be written

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.4 $  $Date: 1994/02/23 22:48:11 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFwriteI2.c 1.4 1994/02/23 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>
#include <libtsp/AFtypes.h>

#define LW		2
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define NBBUF		8192
#define AMIN		(-32768.)
#define AMAX		(32767.)

void
AFwriteI2 (fp, Fbuff, Nval)

     FILE *fp;
     float Fbuff[];
     int Nval;

{
  struct AF_parms *Fparms;
  int is;
  int N;
  int i;
  long int offs;
  int2 Buf[NBBUF /LW];
  int2 *B;
  float Fv;
  int Noverload;
  unsigned char *cp;
  unsigned char t;

/* Get the file format parameters */
  Fparms = AFgetFormat (fp);

  offs = Fparms->End;
  is = 0;
  Noverload = 0;

/* Write data to the audio file */
  while (is < Nval) {
    N = MINV (NBBUF / LW, Nval - is);
    B = Buf;
    for (i = 0; i < N; ++i) {
      Fv = Fparms->ScaleF * Fbuff[i+is];
      if (Fv >= 0) {
	Fv = Fv + 0.5;
	if (Fv >= AMAX + 1.) {
	  ++Noverload;
	  Fv = AMAX;
	}
      }
      else {
	Fv = Fv - 0.5;
	if (Fv <= AMIN - 1.) {
	  ++Noverload;
	  Fv = AMIN;
	}
      }
      *B = Fv;
      if (Fparms->Swapb == DS_SWAP) {
	cp = (unsigned char *) B;
	t = cp[1]; cp[1] = cp[0]; cp[0] = t;
      }
      ++B;
    }
    AFwriteFile (fp, offs, Buf, LW, N);
    is = is + N;
    offs = offs + LW * N;
  }

  /* Update the file position */
  Fparms->End = offs;
  if (Noverload > 0)
    UTwarn ("AFwriteI2: Output data clipped (%d value(s))", Noverload); 
      
}
