/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void AFwriteFile (FILE *fp, int offs, void *ptr, size_t elem_size,
		    size_t count)

Purpose:
  Write raw data to a file

Description:
  This routine writes raw data to a file.  This routine is an interface to
  fwrite, with error checking.  If any error is detected, execution is
  terminated.

Parameters:
  ->  FILE *
  fp -		File pointer associated with the file
  ->  int
  offs -	Byte offset in the file
  ->  void *
  ptr -		Input data buffer
  ->  size_t
  elem_size -	Size of each data element in the input buffer
  ->  size_t
  count -	Number of data elements to be written

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/02/01 02:36:15 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFwriteFile.c 1.3 1994/02/01 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>

#ifndef SEEK_SET	/* normally defined in stdio.h */
#include <unistd.h>
#endif

void
AFwriteFile (fp, offs, ptr, elem_size, count)

     FILE *fp;
     long int offs;
     void *ptr;
     size_t elem_size;
     size_t count;

{
  int Nval;

  if (fseek (fp, offs, SEEK_SET) != 0)
    UTsysErrHalt ("AFwriteFile: Seek error");

  Nval = fwrite (ptr, elem_size, count, fp);
  if (Nval < count)
    UTsysErrHalt ("AFwriteFile: Write error");
}
