/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void AFupdInfoAU (FILE *fp, int Ns)

Purpose:
  Update header information in an AFsp audio file

Description:
  This routine updates the data length field of an AFsp format audio file.  The
  file is assumed to have been opened with routine AFOpenWrite.

Parameters:
  ->  FILE *
  fp -		File pointer for the audio file

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.6 $  $Date: 1994/02/12 20:37:13 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFupdInfoAU.c 1.6 1994/02/12 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>
#include <libtsp/AUparms.h>

void
AFupdInfoAU (fp)

     FILE *fp;
{
  struct AF_parms *Fparms;
  uint4 Ldata;

  Fparms = AFgetFormat (fp);
  if (Fparms->Op != FO_WO)
    UTerrorHalt ("AFupdInfoAU: File not opened for write");

/* Do nothing for headerless files */
  if (Fparms->Start < AU_LHMIN)
    return;

/* Calculate the data length in bytes */
  Ldata = Fparms->End - Fparms->Start;

/* Check if the data should be byte-swapped */
  if (AFbyteOrder () == SF_EL)
    AFswapBytes (&Ldata, U4, 1);

/* Write out the updated data length */
  AFwriteFile (fp, 8, &Ldata, U4, 1);

}
