/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void AFswapBytes (void *Buff, size_t size, int Nelem)

Purpose:
  Swap bytes in an array of values

Description:
  This routine does an in-place swap of the bytes making up each word in an
  array of values.  Swapping bytes involves reversing the order of the
  constituent bytes in each word.

Parameters:
  <-> void *
  Buff -	Array of values, each of size size bytes
  ->  size_t
  size -	Size of each element in bytes.  This value must be 1 (no-op),
		2, 4 or 8.
  ->  int
  Nelem -	Number of values to be byte-swapped

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.7 $  $Date: 1994/02/23 22:48:26 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFswapBytes.c 1.7 1994/02/23 AFsp-V1R2 $";

#include <stddef.h>		/* typedef for size_t */
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>
#include <libtsp/AFtypes.h>

void
AFswapBytes (Buff, size, Nelem)

     void *Buff;
     size_t size;
     int Nelem;

{
  unsigned char *cp;
  int2 *B2;
  int4 *B4;
  double8 *B8;
  unsigned int t;

  switch (size) {
  case (1):
    break;

  case (2):
    B2 = Buff;
    while (Nelem-- > 0) {
      cp = (unsigned char *) B2;
      t = cp[1];  cp[1] = cp[0];  cp[0] = t;
      ++B2;
    }
    break;

  case (4):
    B4 = Buff;
    while (Nelem-- > 0) {
      cp = (unsigned char *) B4;
      t = cp[3];  cp[3] = cp[0];  cp[0] = t;
      t = cp[2];  cp[2] = cp[1];  cp[1] = t;
      ++B4;
    }
    break;

  case (8):
    B8 = Buff;
    while (Nelem-- > 0) {
      cp = (unsigned char *) B8;
      t = cp[7];  cp[7] = cp[0];  cp[0] = t;
      t = cp[6];  cp[6] = cp[1];  cp[1] = t;
      t = cp[5];  cp[5] = cp[2];  cp[2] = t;
      t = cp[4];  cp[4] = cp[3];  cp[3] = t;
      ++B8;
    }
    break;

  default:
    UTerrorHalt ("AFswapBytes: Invalid data element size");
    break;

  }

}
