/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void AFsetFormat (FILE *fp, const struct AF_parms *Fparms)
  struct AF_parms *AFgetFormat (FILE *fp)

Purpose:
  Set audio file format parameters
  Get audio file format parameters

Description:
  This routine uses a file pointer as an index to a structure containing audio
  file parameters.

  AFsetFormat:
  The array of parameters sets is searched for one that matches the given file
  pointer.  If a match is found, the corresponding parameter set is updated.
  However, if the Op code is FO_DEALLOC, the entry is deleted.  If no match is
  found to the file pointer, a parameter set associated with that file pointer
  is created.

  AFgetFormat:
  The array of parameters sets is searched for one that matches the given file
  pointer.  The corresponding parameter set is returned.

Parameters:
  AFsetFormat:
  ->  FILE *
  fp -		File pointer for the audio file
  ->  struct AF_parms *
  Fparms -	Structure containing the audio file parameters

  <-  struct AF_parms *
  AFgetFormat - Structure containing the audio file parameters
  ->  FILE *
  fp -		File pointer for the audio file

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/02/12 20:37:02 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFsetFormat.c 1.5 1994/02/12 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>

#ifndef __STDC__
#define	const
#endif

#define MAXAF	20

struct AF_table {
  FILE *fp;
  struct AF_parms Fparms;
};

static struct AF_table *AFformat[MAXAF];
static int NAF = 0;

void
AFsetFormat (fp, Fparms)

     FILE *fp;
     const struct AF_parms *Fparms;

{
  int i;

/* This routine uses dynamic storage allocation for the parameter structures
   themselves.  However, the array of pointers is of fixed size. */

/* Search for a match to the file pointer */
  for (i = 0; i < NAF; ++i) {

    if (fp == AFformat[i]->fp) {

      /* Found a match - delete or replace the entry */
      if (Fparms->Op == FO_DEALLOC) {
	UTfree (AFformat[i]);
	--NAF;
	for (; i < NAF; ++i) {
	  AFformat[i] = AFformat[i+1];
	}
      }
      else {
	AFformat[i]->Fparms = *Fparms;
      }
      return;
    }

  }
  /* Error check */
  if (Fparms->Op == FO_DEALLOC)
    UTerrorHalt ("AFsetFormat: No match to the file pointer");

/* Add a new parameter set */
  if (i > MAXAF)
    UTerrorHalt ("AFsetFormat: Too many audio files open");
  AFformat[i] = (struct AF_table *) UTmalloc (sizeof (struct AF_table));

  /* Fill in the structure */
  AFformat[i]->fp = fp;
  AFformat[i]->Fparms = *Fparms;
  ++NAF;

}

struct AF_parms *
AFgetFormat (fp)

     FILE *fp;

{
  int i;

/* Search for a match to the file pointer */
  for (i = 0; i < NAF; ++i) {
    if (AFformat[i]->fp == fp) {
      return &(AFformat[i]->Fparms);
    }
  }
  UTerrorHalt ("AFgetFormat: No match to the file pointer");

}
