/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int AFsepRecSP (const char name[], int type, void *data, int errcont,
		   const char head[], int N)

Purpose:
  Find a named record in a NIST SPHERE audio file header

Description:
  This routine searches through records in the header of an NIST SPHERE audio
  file, looking for a record with a given name field.  For the purpose of this
  routine, a name is the leading part of a record, separated from the type and
  value fields by a blank.  This routine returns a pointer to the beginning of
  the type field.

  In the syntax for NIST SPHERE headers, a newline character marks the end of a
  record.  But, the header syntax also allows for any character, including a
  newline character, to appear within a string value.  To avoid parsing each
  record to find the end of record, this routine assumes all newline characters
  terminate records.  Any newline character imbedded in a string value must not
  be followed by a sequence of characters which would be mistaken for the name
  field at the beginning of a record.

Parameters:
  <-  int
  AFgetRecSP -	Returned error status, 0 for no error, 1 for error
  ->  const char []
  name - 	Record name to be matched
  head -	Character string (N characters) with the header records
  ->  int
  N -		Length of the header string

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.2 $  $Date: 1994/01/23 03:23:23 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFsepRecSP.c 1.2 1994/01/23 AFsp-V1R2 $";

#include <string.h>
#include <libtsp/AFnucleus.h>

#ifndef __STDC__
#define	const
#endif


char *
AFsepRecSP (name, head, N)

     const char name[];
     const char head[];
     int N;

{
  const char *pst;
  const char *h_end;
  const char *r_term;
  int lenn;

  h_end = &head[N-1];
  pst = head;
  lenn = strlen (name);
  while (pst <= h_end) {

    /* Find the record terminator */
    r_term = (char *) memchr (pst, '\n', h_end - pst + 1);
    if (r_term == NULL)
      break;

    /* Check for a name match */
    if (r_term - pst >= lenn + 1 && memcmp (pst, name, lenn) == 0
	&& pst[lenn] == ' ') {
      return ((char *) (pst + lenn + 1));
    }
    pst = r_term + 1;
  }

/* No match to the name */
  return NULL;
}
