/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int AFreadI2 (FILE *fp, long int offs, float Fbuff[], int Nreq)

Purpose:
  Read 16-bit integer data from an audio file (return float values)

Description:
  This routine reads a specified number of 16-bit integer samples from an audio
  file.  The data in the file is converted to float format on output. The file
  must have been opened using subroutine AFopenRead.

Parameters:
  <-  int
  AFreadI2 -	Number of data values transferred from the file.  On reaching
		reaching the end of the file, this value may be less than Nreq.
  ->  FILE *
  fp -		File pointer for a file opened by AFopenRead
  ->  long int
  offs -	Offset into the file in samples.  The parameter offs must be
                non-negative.
  <-  float []
  Fbuff -	Array of floats to receive the samples
  ->  int
  Nreq -	Number of samples requested.  Nreq may be zero.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.8 $  $Date: 1994/02/23 22:47:57 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFreadI2.c 1.8 1994/02/23 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>
#include <libtsp/AFtypes.h>

#define LW		2
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define NBBUF		8192

int
AFreadI2 (fp, offs, Fbuff, Nreq)

     FILE *fp;
     long int offs;
     float Fbuff[];
     int Nreq;

{
  struct AF_parms *Fparms;
  long int offsb;
  int Nd;
  int is;
  int n;
  int i;
  int2 Buf[NBBUF / LW];
  int2 *B;
  unsigned char *cp;
  unsigned char t;
  int Nval;

/* Get the file format parameters */
  Fparms = AFgetFormat (fp);

  offsb = Fparms->Start + LW * offs;
  Nd = MINV (Nreq, (Fparms->End - offsb) / LW);
  is = 0;

/* Read data from the audio file */
  while (1) {
    n = MINV (NBBUF / LW, Nd);
    if (n <= 0)
      break;
    Nval = AFreadFile (fp, offsb, Buf, LW, n);
    if (Nval != n)
      UTerrorHalt ("AFreadI2: Unexpected end-of-file");

    /* Byte swap and convert to float */
    B = Buf;
    for (i = 0; i < Nval; ++i) {
      if (Fparms->Swapb == DS_SWAP) {
	cp = (unsigned char *) B;
	t = cp[1]; cp[1] = cp[0]; cp[0] = t;
      }
      Fbuff[i+is] = Fparms->ScaleF * (*B);
      ++B;
    }
    is = is + Nval;
    Nd = Nd - Nval;
    offsb = offsb + LW * Nval;
  }

  return is;
}
