/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int AFreadFile (FILE *fp, int offs, void *ptr, size_t elem_size,
                  size_t count)

Purpose:
  Read raw data from a file

Description:
  This routine reads raw data from a file.  This routine is an interface to
  fread, with error checking.  If any error is detected (other than end-of-
  file), execution is terminated.

Parameters:
  <-  int
  AFreadFile -	Number of values read from the file.  This value is less than
		count only if end-of-file is reached.
  ->  FILE *
  fp -		File pointer associated with the file
  ->  int
  offs -	Byte offset in the file
  <-  void *
  ptr -		Output data buffer
  ->  size_t
  elem_size -	Size of each data element in the output buffer
  ->  size_t
  count -	Number of data elements to be read

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.9 $  $Date: 1994/02/01 02:37:05 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFreadFile.c 1.9 1994/02/01 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>

#ifndef SEEK_SET	/* normally defined in stdio.h */
#include <unistd.h>
#endif

int
AFreadFile (fp, offs, ptr, elem_size, count)

     FILE *fp;
     long int offs;
     void *ptr;
     size_t elem_size;
     size_t count;

{
  int Nval;

  if (fseek (fp, offs, SEEK_SET) != 0)
    UTsysErrHalt ("AFreadFile: Seek error");

  Nval = fread (ptr, elem_size, count, fp);
  if (Nval < count) {
    if (! feof (fp))
      UTsysErrHalt ("AFreadFile: Read error");
  }
  return Nval;
}
