/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  char *AFgetRecAU (const char name[], const char head[], int N)

Purpose:
  Find a named record in an AFsp audio file header

Description:
  This routine searches through records in the header of an AFsp audio file,
  looking for a match to a record with a given name.  A pointer to the data
  value for that record is returned.

  AFsp audio file headers allow for an arbitrary length information field
  following a fixed format portion of the header.  For the purpose of this
  routine, the information field is assumed to consist of records of data
  terminated by nulls.  If the header does not follow this format, this routine
  will not find records to match and will silently return a NULL pointer.

  AFsp Header Information Records:
    The header information records are separated by null characters.  The name
    field is the first part of the record and the value field is the remainder.
    Standard names are terminated by a ':' character, which effectively
    delimits the name field from the value field.

Parameters:
  <-  char *
  AFgetRecSP -	Pointer to a null terminated value string in head.
  ->  const char []
  name - 	Record name to be matched.  An empty name will match the first
		record.
  ->  const char []
  head -	Array of N characters containing the  header records.  This
		should be the part of the audio file header beyond the 28 byte
		fixed format part of the data in the file.  This array should
		have a null byte in its last position if this routine is to
		find the last record.
  ->  int
  N -		Length of the header string

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.10 $  $Date: 1994/02/09 04:36:14 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFgetRecAU.c 1.10 1994/02/09 AFsp-V1R2 $";

#include <string.h>
#include <libtsp/AFnucleus.h>

#ifndef __STDC__
#define	const
#endif


char *
AFgetRecAU (name, head, N)

     const char name[];
     const char head[];
     int N;

{
  const char *pst;
  const char *h_end;
  const char *r_term;
  int lenn;

  h_end = &head[N];
  pst = head;
  lenn = strlen (name);
  while (pst < h_end) {

    /* Find the record terminator */
    r_term = (char *) memchr (pst, '\0', h_end - pst);
    if (r_term == NULL)
      break;

    /* Check for a name match */
    if (r_term - pst >= lenn && memcmp (pst, name, lenn) == 0 ) {
      return ((char *) (pst + lenn));
    }
    pst = r_term + 1;
  }

/* No match to the name */
  return NULL;
}
