/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  long int AFfileSize (FILE *fp)

Purpose:
  Find the size of a file

Description:
  This routine finds the size of a binary file.  The size of the file is
  determined by positioning to end-of-file and returning the end-of-file
  position.  On exit, the file position is restored to the original position.

Parameters:
  <-  long int
  AFfileSize -	File size in bytes
  ->  FILE *
  fp -		File pointer associated with the file

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.11 $  $Date: 1994/02/23 22:44:02 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFfileSize.c 1.11 1994/02/23 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>

#ifndef SEEK_SET	/* normally defined in stdio.h */
#include <unistd.h>
#endif

long int
AFfileSize (fp)

     FILE *fp;

{
  long int pos;
  long int endpos;

/*
   The ANSI C standard does not guarantee that this method of determining
   the file size will work on all systems.  It works on Unix systems and
   probably a lot of other systems.  The alternative is to use stat, but that
   is probably even less portable.
   */
  pos = ftell (fp);
  if (pos == EOF)
    UTsysErrHalt ("AFfileSize: Cannot determine file position");

  if (fseek (fp, 0L, SEEK_END) != 0)
    UTsysErrHalt ("AFfileSize: File positioning error");

  endpos = ftell (fp);
  (void) fseek (fp, pos, SEEK_SET);

  return endpos;
}
