/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int AFcheckIEEE (void)

Purpose:
  Check if host uses IEEE standard 754 format for float values

Description:
  This routine determines if the current host uses IEEE standard 754 format to
  represent float values.

Parameters:
  <-  int
  AFcheckIEEE -	Output flag, 0 if host uses IEEE float format, 1 otherwise

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/02/23 22:43:39 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFcheckIEEE.c 1.5 1994/02/23 AFsp-V1R2 $";

#include <libtsp/AFnucleus.h>
#include <libtsp/AFtypes.h>

#ifndef __STDC__
#define	const
#endif

int
AFcheckIEEE ()

{
  /* IEEE float value check values */
  static const uint4 IEEEiv = 0xc3268000;
  static const float4 IEEEfv = -166.5;

  union {
    float4 fv;
    uint4 iv;
  } Floatv;

/* Store a float value and check the bit pattern of the result */
  Floatv.fv = IEEEfv;
  if (Floatv.iv != IEEEiv)
    return 1;
  else
    return 0;
}
