/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  int AFbyteOrder (void)

Purpose:
  Determine the byte order for data storage

Description:
  This function returns a code indicating whether the storage order the current
  host is little-endian or big-endian.  For big-endian machines the constituent
  bytes in a multi-byte entity are stored starting with the most significant
  byte, ending with the least significant byte.  For little-endian machines,
  bytes are stored from least significant to most significant.

Parameters:
  <-  int
  AFbyteOrder -	Returned integer code
		0 - Big-endian storage order
		1 - Little-endian storage order

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.10 $  $Date: 1994/02/24 14:33:24 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFbyteOrder.c 1.10 1994/02/24 AFsp-V1R2 $";

#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>
#include <libtsp/AFtypes.h>

#ifndef __STDC__
#define	const
#endif

int
AFbyteOrder ()

{
  enum { C0 = 1, C1 = 2, C2 = 4, C3 = 8 };
  union { uint4 U; unsigned char C[U4]; } u;
  static const uint4 I4L = (C0 + C1*256 + C2*(256*256) + C3*(256*256*256));
  static const uint4 I4B = (C3 + C2*256 + C1*(256*256) + C0*(256*256*256));
  int byte_order;

  u.C[0] = C0;
  u.C[1] = C1;
  u.C[2] = C2;
  u.C[U4-1] = C3;	/* Implicit check that sizeof (uint4) is 4 */
  if (u.U == I4L)
    byte_order = SF_EL;
  else if (u.U == I4B)
    byte_order = SF_EB;
  else
    UTerrorHalt ("AFbyteOrder: Word sizes wrong or unsupported byte ordering");

  return byte_order;
}
