/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void AFwriteData (FILE *fp, float Fbuff[], int Nval)

Purpose:
  Write data to an audio file (float input values)

Description:
  This routine writes a specified number of samples to an audio file.  The
  float input data is converted to the audio file data representation.  The
  file data representation is set on opening the file with routine AFopenWrite.
  This routine writes data sequentially to the file.

Parameters:
  FILE *
  fp -		File pointer for a file opened by AFopenWrite
  ->  float []
  Fbuff -	Array of floats with Nval samples
  ->  int
  Nval -	Number of samples to be written

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.2 $  $Date: 1994/02/12 20:35:52 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFwriteData.c 1.2 1994/02/12 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>

void
AFwriteData (fp, Fbuff, Nval)

     FILE *fp;
     float Fbuff[];
     int Nval;

{
  struct AF_parms *Fparms;

/* Get the file format */
  Fparms = AFgetFormat (fp);
  if (Fparms->Op != FO_WO)
    UTerrorHalt ("AFwriteData: File not opened for write");

/* Transfer data to the audio file */
  switch (Fparms->Format) {

  case FD_FLOAT32:
    AFwriteF4 (fp, Fbuff, Nval);
    break;

  case FD_LIN16:
    AFwriteI2 (fp, Fbuff, Nval);
    break;

  case FD_MULAW8:
    AFwriteMulaw (fp, Fbuff, Nval);
    break;

  default:
    UTerrorHalt ("AFwriteData: Unsupported data format");
    break;
  }
}
