/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  FILE *AFopenWrite (const char Fname[], int Format, long int Nchan,
  		     float *Sfreq, FILE *fpout)

Purpose:
  Open an audio file for writing

Description:
  This routine opens an audio file for writing.  This routine sets up the audio
  file parameters to write data of the given format to the audio file.  It
  normally writes a file header in AFsp audio file format.  After writing data
  to the file, the routine AFclose should be called to update the file header
  information and close the file.

  The AFsp audio file format uses a file header which is compatible with a
  Sun/NeXT audio file header.
      Bytes     Type    Contents
     0 ->  3    int    File identifier
     4 ->  7    int    Header size H (bytes)
     8 -> 11    int    Audio data length (bytes)
    12 -> 15    int    Data encoding format
    16 -> 19    int    Sample rate (samples per second)
    20 -> 23    int    Number of interleaved channels
    24 -> 27	int    AFsp identifier
    28 -> H-1   --     Additional header information
  By default, information consisting of the date, the user and the program
  creating the file is written to the header.  Routine AFsetInfo can be called
  before calling this routine to specify additional information to be written
  to the header.

  The data in the audio file can consist of 8-bit mu-law, 16 bit linear or
  32-bit IEEE floating point data.  Conversion parameters for subsequent write
  operations are set up as follows.
    8-bit mu-law       -->  [ -32124 , +32124 ]
    16-bit linear      -->  [ -32768 , +32767 ]
    32-bit IEEE float  -->  scaled by 1/32768  (file data values nominally
                            between -1 and +1)

Parameters:
  <-  FILE *
  AFopenWrite -	File pointer for the audio file
  ->  const char []
  Fname -	Character string specifying the file name
  Format -	Audio file data format code, evaluated as
		Format = Dformat + 256 * NH + 512 * Swapb
		Dformat - data format
		  1, mu-law 8-bit data
		  2, linear twos complement 16-bit data
		  3  32-bit float data
                NH - header flag
                  0, AFsp file header (data in big-endian byte order)
		  1, no header
		Swapb - swap flag.  For AFsp files, the byte swap flage must
		  must resulst in big-endian data.
		  0, big-endian byte order (illegal for AFsp files)
		  1, little-endian byte order
		  2, native (no swap) byte order
		  3, byte-swapped
  ->  long int
  Nchan -	Number of channels
  ->  float *
  Sfreq -	Sampling frequency
  ->  FILE *
  fpout  -	File pointer for printing audio file information.  If fpout is
		not NULL, information about the audio file is printed on the
		stream selected by fpout.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.7 $  $Date: 1994/02/04 16:25:16 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFopenWrite.c 1.7 1994/02/04 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>

#ifndef __STDC__
#define	const
#endif

FILE *
AFopenWrite (Fname, Format, Nchan, Sfreq, fpout)

     const char Fname[];
     int Format;
     long int Nchan;
     float *Sfreq;
     FILE *fpout;

{
  FILE *fp;

/* Open the file for writing */
  fp = fopen (Fname, "wb");
  if (fp == NULL)
    UTsysErrHalt ("AFopenWrite: Cannot open file \"%s\"", Fname);

/* Write and print the header information */
  AFsetInfoAU (fp, Fname, Format, Nchan, Sfreq, fpout);

  return fp;
}
