/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  FILE *AFopenRead (const char Fname[], long int *Nsamp, long int *Nchan,
		    float *Sfreq, FILE *fpout)

Purpose:
  Open an audio file for reading

Description:
  This routine opens an audio file for reading.  If unsuccessful, the program
  is terminated.  The companion routine AFreadData reads data from the file.
  Routine AFclose should be used to close the file.

  This routine reads the audio file header and optionally prints the header
  information.  Several file header formats are supported.  For files with
  unrecognized headers, the file format can be specified by calling routine
  AFsetNH before calling this routine.

  AFsp (also Sun/NeXT/DEC) audio file header:
      Bytes     Type    Contents
     0 ->  3    int    File identifier
     4 ->  7    int    Header size H (bytes)
     8 -> 11    int    Audio data length (bytes)
    12 -> 15    int    Data encoding format
    16 -> 19    int    Sample rate (samples per second)
    20 -> 23    int    Number of interleaved channels
    24 -> 27    int    AFsp identifier
    28 -> H-1   --     Additional header information
     H -> ...   --     Audio data
  For AFsp (Sun/NeXT/DEC) audio files, 8-bit mu-law, 16-bit linear and 32-bit
  IEEE floating point data formats are supported.

  NIST SPHERE audio file:
     Bytes      Type    Contents
    0 ->  7     char   NIST_1A file identifier
    8 -> 15     char   Header length in ASCII (1024)
   16 -> H-1    struct Object-oriented fields
  For NIST SPHERE audio files, 16-bit linear data encoding is supported.

  ESPS sampled data feature file header:
      Bytes     Type    Contents
     8 -> 11    --     Header size (bytes)
    12 -> 15    int    Sampled data record size
    16 -> 19    int    File identifier
    40 -> 65    char   File creation date
   124 -> 127   int    Number of samples (may indicate zero)
   132 -> 135   int    Number of doubles in a data record
   136 -> 139   int    Number of floats in a data record
   140 -> 143   int    Number of longs in a data record
   144 -> 147   int    Number of shorts in a data record
   148 -> 151   int    Number of chars in a data record
   160 -> 167   char   User name
   333 -> H-1   --     Generic header items, including "record_freq"
     H -> ...   --     Audio data
  For ESPS sampled data feature files, 16-bit linear and 32-bit IEEE floating
  point data formats are supported.

  IRCAM SoundFile header:
      Bytes     Type    Contents
     0 ->  3    int    File identifier
     4 ->  7    float  Sampling Frequency
     8 -> 11    int    Number of Channels
    12 -> 15    int    Data Type
    16 -> 1023  --     Additional header information
  1024 -> ...   --     Audio data
  For IRCAM SoundFiles, 16-bit linear and 32-bit IEEE floating point data
  formats are supported.

  INRS-Telecommunications audio file:
      Bytes     Type    Contents
     0 ->  3    float  Sampling Frequency (VAX float format)
     6 -> 25    char   Creation time (e.g. Jun 12 16:52:50 1990)
    26 -> 29    int    Number of speech samples in the file
  The data in an INRS-Telecommunications audio file is in 16-bit integer
  format.

  Conversion parameters for subsequent read operations are set up to scale
  data as follows.
  AFsp (Sun/NeXT/DEC) audio file:
    8-bit mu-law       -->  [ -32124 , +32124 ]
    16-bit linear      -->  [ -32768 , +32767 ]
    32-bit IEEE float  -->  scaled by 32768  (file data values nominally
                            between -1 and +1)

  NIST SPHERE audio files:
    16-bit linear      -->  [ -32768 , +32767 ]

  ESPS sampled data feature file:
    16-bit linear      -->  [ -32768 , +32767 ]
    32-bit IEEE float  -->  unity scale factor

  IRCAM SoundFile:
    16-bit linear      -->  [ -32768 , +32767 ]
    32-bit IEEE float  -->  unity scale factor

  INRS-Telecommunications audio file:
    16-bit linear      -->  [ -32768 , +32767 ]

Parameters:
  <-  FILE *
  AFopenRead -	File pointer for the audio file
  ->  const char []
  Fname -	Character string specifying the file name
  <-  long int *
  Nsamp -	Total number of samples in the file (all channels)
  <-  long int *
  Nchan -	Number of channels
  <-  float *
  Sfreq -	Sampling frequency
  ->  FILE *
  fpout  -	File pointer for printing audio file information.  If fpout is
		not NULL, information about the audio file is printed on the
		stream selected by fpout.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.10 $  $Date: 1994/02/04 14:56:15 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFopenRead.c 1.10 1994/02/04 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>

#ifndef __STDC__
#define	const
#endif

FILE *
AFopenRead (Fname, Nsamp, Nchan, Sfreq, fpout)

     const char Fname[];
     long int *Nsamp;
     long int *Nchan;
     float *Sfreq;
     FILE *fpout;

{
  FILE *fp;

/* Open the file for reading */
  fp = fopen (Fname, "rb");
  if (fp == NULL)
    UTsysErrHalt ("AFopenRead: Cannot open file \"%s\"", Fname);

/* Read and print the header information */
  switch (AFfileType (fp)) {
  case FT_AFSP:
  case FT_SUN:
  case FT_DEC:
    AFgetInfoAU (fp, Fname, Nsamp, Nchan, Sfreq, fpout);
    break;

  case FT_SPHERE:
    AFgetInfoSP (fp, Fname, Nsamp, Nchan, Sfreq, fpout);
    break;

  case FT_ESPS:
    AFgetInfoES (fp, Fname, Nsamp, Nchan, Sfreq, fpout);
    break;

  case FT_NH:
    AFgetInfoNH (fp, Fname, Nsamp, Nchan, Sfreq, fpout);
    break;

  case FT_SF:
    AFgetInfoSF (fp, Fname, Nsamp, Nchan, Sfreq, fpout);
    break;

  case FT_INRS:
    AFgetInfoIN (fp, Fname, Nsamp, Nchan, Sfreq, fpout);
    break;

  default:
    fclose (fp);
    UTerrorHalt ("AFopenRead: Unsupported audio file format");
    break;
  }

  return fp;
}
