/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void AFclose (FILE * fp)

Purpose:
  Close an audio file

Description:
  This routine closes an audio file opened with AFopenRead or AFopenWrite.  If
  the file was opened for write, the file header is updated with the number of
  samples in the file.  For both read and write operations, the file format
  parameters associated with the the file pointer are deallocated and the file
  is closed.

Parameters:
  ->  FILE *
  fp -		File pointer for the audio file

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/02/16 19:58:18 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFclose.c 1.5 1994/02/16 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/AFnucleus.h>
#include <libtsp/AFparms.h>

void
AFclose (fp)

     FILE *fp;

{
  struct AF_parms *Fparms;

/* Get the file format parameters */
  Fparms = AFgetFormat (fp);

/* Update the header for output files */
  if (Fparms->Op == FO_WO)
    AFupdInfoAU (fp);

/* Deallocate the parameter set */
  Fparms->Op = FO_DEALLOC;
  AFsetFormat (fp, Fparms);

/* Close the file */
  fclose (fp);

}
