/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  STnucleus.h

Description:
  Function prototypes for the TSP string nucleus routines.  The system include
  file stddef.h is also brought in by this file.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/02/11 14:40:14 $

----------------------------------------------------------------------*/

#ifndef __STnucleus_H__
#define __STnucleus_H__

#include <stddef.h>		/* defines size_t */

#ifdef __STDC__
#	define p_(params)	params
#else
#	define p_(params)	()
#endif

/* Prototypes */

char *
STstrstrNM p_((const char Si[], const char Ti[], size_t N, size_t M));
char *
STtrimIws p_((const char Si[]));
void
STtrimNMax p_((const char Si[], char So[], size_t N, size_t Maxchar));

#endif /* __STnucleus_H__ */
