/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  FIparms.h

Description:
  Define parameters used by the TSP filter routines.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.4 $  $Date: 1994/02/07 03:37:54 $

----------------------------------------------------------------------*/

#ifndef __FIPARMS_H__
#define __FIPARMS_H__

#ifndef __STDC__
#	define	_CONST
#else
#	define	_CONST	const
#endif

/* Filter types */
enum {
  FI_UNDEF	= 0,	/* undefined file data format */
  FI_FIR	= 1,	/* FIR filter, direct form */
  FI_IIR	= 2,	/* IIR filter, cascade of biquad sections */
  FI_ALL	= 3,	/* All-pole filter, direct form */
  FI_WIN	= 4,	/* Window coefficients, direct form */
  FI_CAS	= 5	/* Cascade analog biquad sections */
};

/* String descriptions of filter types */
static _CONST char *FItype[] = {
  "Undefined filter type",
  "FIR filter (direct form)",
  "IIR filter (cascade biquad sections)",
  "All-pole filter (direct form)",
  "Window coefficients",
  "Analog filter (Cascade biquad sections)"
};

/* Keyword templates for filter types */
static _CONST char *FItab[] = {
  "!FIR**",	/* FIR filter, direct form */
  "!IIR**",	/* IIR filter, cascade of biquad sections */
  "!ALL**",	/* All-pole filter, direct form */
  "!WIN**",	/* Window coefficients, direct form */
  "!CAS**",	/* Cascade analog biquad sections */
  NULL
};

#undef	_CONST

#endif	/* __FIPARMS_H__ */
