/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  ESparms.h

Description:
  Define parameters for ESPS sampled data feature file headers for the TSP
  audio file routines.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/02/07 03:35:33 $

----------------------------------------------------------------------*/

#ifndef __ESPARMS_H__
#define __ESPARMS_H__

#ifndef __STDC__
#	define	_CONST
#else
#	define	_CONST	const
#endif

/* Typedef's for variable types uint4, etc */
#include <libtsp/AFtypes.h>

#define	ES_LHMIN	(sizeof (struct ES_preamb) + sizeof (struct ES_head))
#define	ES_MXINFO	(8192)

/*  File magic values, for a file written in big-endian byte order as read in
    by a {big-endian, little-endian} machine
    ESPS files can be written in either big-endian or little-endian byte order.
*/
static _CONST uint4 FM_ESPS[2] = {0x00006a1a, 0x1a6a0000};

struct ES_preamb {
  uint4 Machine_code;	/* machine which wrote file */
  uint4 Check_code;	/* version check code */
  uint4 Data_offset;	/* data offset in bytes */
  uint4 Record_size;	/* record size */
  uint4 Magic;		/* file magic */
  uint4 Edr;		/* EDR_ESPS flag */
  uint4 Align_pad_size;	/* alignment pad */
  int4 Foreign_hd;	/* pointer to foreign header */
};

struct ES_head {
  uint2 Type;		/* File type (13) */
  uint2 fill;
  uint4 Magic;		/* File magic */
  char Datetime[26];	/* File creation date */
  char Version[8];	/* Header version */
  char Prog[16];	/* Program name */
  char Vers[8];		/* Program version */
  char Progdate[26];	/* Program compile date */
  int4 Ndrec;		/* Number of data records */
  uint4 Tag;
  uint4 Ndouble;
  uint4 Nfloat;
  uint4 Nlong;
  uint4 Nshort;
  uint4 Nchar;
  uint4 Fixsiz;		/* Fixed header size (40) ?? */
  uint4 Hsize;		/* Variable header size ?? */
  char User[8];
			/* more unknown fields */
};

/* Structure for record frequency */
/* Byte alignment problems cause holes in this structure */
struct ES_recfreq {
  int2 code1;		/* code1 == 3 */
  int2 code2;		/* code2 == 3 */
  char c[12];		/* "record_freq" */
  int4 count;		/* count == 1 */
  uint2 data_code;	/* data_code == 1 (double) */
  double8 sfreq;	/* sampling frequency */
};

#endif	/* __ESPARMS_H__ */
