/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  AUparms.h

Description:
  Define parameters for AFsp (and Sun/DEC) audio file headers for the TSP audio
  file routines.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.4 $  $Date: 1994/02/07 03:34:37 $

----------------------------------------------------------------------*/

#ifndef __AUPARMS_H__
#define __AUPARMS_H__

#ifndef __STDC__
#	define	_CONST
#else
#	define	_CONST	const
#endif

/* Typedef for uint4 */
#include <libtsp/AFtypes.h>

#define AU_LHMIN	(sizeof (struct AU_head))
#define AU_MXINFO	(1024 - AU_LHMIN)

/*
 File magic values, as read in by a {big-endian, little-endian} machine.
 AFsp and Sun files are written in big-endian byte order, while DEC files
 are written in little-endian byte order.
*/
static _CONST uint4 FM_SUN[2]  = {0x2e736e64, 0x646e732e};	/* ".snd"  */
static _CONST uint4 FM_DEC[2]  = {0x2e736400, 0x0064732e};	/* ".sd\0" */
static _CONST uint4 FM_AFSP[2] = {0x41467370, 0x70734641};	/* "AFsp"  */ 

enum {
  AU_UNSPEC	= 0,	/* unspecified format */
  AU_MULAW8	= 1,	/* mu-law 8-bit data */
  AU_LIN8	= 2,	/* linear twos complement 8-bit data */
  AU_LIN16	= 3,	/* linear twos complement 16-bit data */
  AU_LIN24	= 4,	/* linear twos complement 24-bit data */
  AU_LIN32	= 5,	/* linear twos complement 32-bit data */
  AU_FLOAT32	= 6,	/* IEEE 32-bit float data (-1. to +1.) */
  AU_ALAW8	= 27,	/* A-law 8-bit data */
};

enum {
  AU_NOSIZE	= (~0L)	/* Indeterminate data length */
};

struct AU_head {
  uint4 Magic;	/* File magic */
  uint4 Lhead;	/* Length of header in bytes */
  uint4 Ldata;	/* Length of data portion in bytes */
  uint4 Dencod;	/* Encoding type */
  uint4 Srate;	/* Sampling rate */
  uint4 Nchan;	/* Number of channels */
  uint4 AFsp;	/* AFsp identifier */
};

#endif	/* __AUPARMS_H__ */
