/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  AFparms.h

Description:
  Define parameters used by the TSP audio file routines.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.9 $  $Date: 1994/02/04 16:39:41 $

----------------------------------------------------------------------*/

#ifndef __AFPARMS_H__
#define __AFPARMS_H__

/* Structure for headerless audio files */
struct AF_NH {
  int   Format;		/* data format */
  int   Start;		/* offset in bytes to the start of data */
  float Sfreq;		/* sampling frequency */
  int   Swapb;		/* byte swap flag */
  int   Nchan;		/* number of channels */
  float ScaleF;		/* scale factor */
};

/* Audio file parameters */
struct AF_parms {
  int Op;		/* operation (null, read, write) */
  int Format;		/* data format */
  long int Start;	/* start byte */
  long int End;		/* end-of-file byte */
  int Swapb;		/* swap flag */
  float ScaleF;		/* scaling factor */
};

/* Data format types */
enum {
  FD_UNDEF	= 0,	/* undefined file data format */
  FD_MULAW8	= 1,	/* mu-law 8-bit data */
  FD_LIN16	= 2,	/* linear twos complement 16-bit data */
  FD_FLOAT32	= 3	/* 32-bit float data */
};
#define	FD_NH	256	/* headerless file flag */
#define	FD_BO	512	/* byte order offset */

/* Machine byte order types */
enum {
  SF_EB		= 0,	/* big-endian */
  SF_EL		= 1	/* little-endian */
};

/* Byte order values */
enum {
  DS_EB		= SF_EB,	/* big-endian format data */
  DS_EL		= SF_EL,	/* little-endian format data*/
  DS_NATIVE	= 2,		/* native (no swap) format data */
  DS_SWAP	= 3		/* byte-swapped format data */
};

/* Audio file types */
enum {
  FT_UNKNOWN	= 0,	/* unknown audio file format */
  FT_NH		= 1,	/* headerless (non-standard or no header) audio file */
  FT_AFSP	= 2,	/* AFsp audio file */
  FT_SUN	= 3,	/* Sun/Next audio file */
  FT_DEC	= 4,	/* DEC audio file */
  FT_SPHERE	= 5,	/* NIST SPHERE audio file */
  FT_ESPS	= 6,	/* ESPS sampled data feature file */
  FT_SF		= 7,	/* IRCAM SoundFile audio file */
  FT_INRS	= 8	/* INRS-Telecom audio file */
};

/* File operation types */
enum {
  FO_DEALLOC = 0,	/* deallocate parameter structure */
  FO_RO = 1,		/* read */
  FO_WO = 2		/* write */
};

#endif	/* __AFPARMS_H__ */
