/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  AFnucleus.h

Description:
  Procedure prototypes for the TSP audio file nucleus routines.  The system
  include files stddef.h and stdio.h are included by this file.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.8 $  $Date: 1994/02/12 23:37:17 $

----------------------------------------------------------------------*/

#ifndef __AFnucleus_H__
#define __AFnucleus_H__

#include <stdio.h>	/* typedef for FILE and size_t */
			/* defines FILENAME_MAX */

/* For non-ANSI headers */
#include <stddef.h>	/* typedef for size_t */

#ifdef __STDC__
#	define p_(params)	params
#else
#	define p_(params)	()
#endif

/* Prototypes */

struct AF_parms;	/* incomplete definition */
struct AF_NH;		/* incomplete definition */

int
AFbyteOrder p_((void));
int
AFcheckIEEE p_((void));
long int
AFfileSize p_((FILE *fp));
int
AFfileType p_((FILE *fp));
struct AF_parms *
AFgetFormat p_((FILE *fp));
char *
AFgetUinfo p_((float *Sfreq, int *Nchar));
void
AFgetInfoAU p_((FILE *fp, const char Fname[], long int *Nsamp,
		long int *Nchan, float *Sfreq, FILE *fpout));
void
AFgetInfoES p_((FILE *fp, const char Fname[], long int *Nsamp,
		long int *Nchan, float *Sfreq, FILE *fpout));
void
AFgetInfoIN p_((FILE *fp, const char Fname[], long int *Nsamp,
		long int *Nchan, float *Sfreq, FILE *fpout));
void
AFgetInfoNH p_((FILE *fp, const char Fname[], long int *Nsamp,
		long int *Nchan, float *Sfreq, FILE *fpout));
void
AFgetInfoSF p_((FILE *fp, const char Fname[], long int *Nsamp,
		long int *Nchan, float *Sfreq, FILE *fpout));
void
AFgetInfoSP p_((FILE *fp, const char Fname[], long int *Nsamp,
		long int *Nchan, float *Sfreq, FILE *fpout));
char *
AFgetRecAU p_((const char name[], const char head[], int N));
int
AFgetRecSP p_((const char name[], int type, void *data, int errcont,
	       const char head[], int N));
struct AF_NH *
AFgetNH p_((void));
int
AFreadF4 p_((FILE *fp, long int offs, float Fbuff[], int Nreq));
int
AFreadFile p_((FILE *fp, long int offs, void *ptr, size_t elem_size,
	       size_t count));
int
AFreadI2 p_((FILE *fp, long int offs, float Fbuff[], int Nreq));
int
AFreadMulaw p_((FILE *fp, long int offs, float Fbuff[], int Nreq));
char
*AFsepRecSP p_((const char name[], const char head[], int N));
void
AFsetFormat p_((FILE *fp, const struct AF_parms *Fparms));
void
AFsetInfoAU p_((FILE *fp, const char Fname[], int Format, long int Nchan,
		float *Sfreq, FILE *fpout));
void
AFswapBytes p_((void *Buff, size_t size, int Nelem));
void
AFwriteF4 p_((FILE *fp, float Fbuff[], int Nval));
void
AFwriteFile p_((FILE *fp, long int offs, void *ptr, size_t elem_size,
		size_t count));
void
AFwriteI2 p_((FILE *fp, float Fbuff[], int Nval));
void
AFwriteMulaw p_((FILE *fp, float Fbuff[], int Nval));

#endif /* __AFnucleus_H__ */
