/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  libtsp.h

Description:
  Procedure prototypes for the TSP library routines

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.7 $  $Date: 1994/02/24 00:57:08 $

----------------------------------------------------------------------*/

#ifndef __LIBTSP_H__
#define __LIBTSP_H__

#include <stdio.h>	/* typedef for FILE and size_t */
			/* defines FILENAME_MAX */

/* For non-ANSI headers */
#include <stddef.h>	/* typedef for size_t */
#ifndef FILENAME_MAX	/* normally in stdio.h */
#	include <sys/param.h>
#	define	FILENAME_MAX	MAXPATHLEN
#endif

/* For HPUX */
#ifdef hpux
#	undef	FILENAME_MAX	/* defined in stdio.h as 14 */
#	include <sys/param.h>
#	define	FILENAME_MAX	MAXPATHLEN
#endif

#ifdef __STDC__
#	define p_(params)	params
#else
#	define p_(params)	()
#endif

/* ----- AF Prototypes ----- */
void
AFclose p_((FILE *fp));
char *
AFgetHinfo p_((FILE *fp, int *Ninfo));
FILE *
AFopenRead p_((const char Fname[], long int *Nsamp, long int *Nchan,
	       float *Sfreq, FILE *fpout));
FILE *
AFopenWrite p_((const char Fname[], int Format, long int Nchan,
		float *Sfreq, FILE *fpout));
int
AFreadData p_((FILE *fp, long int offs, float Fbuff[], int Nreq));
void
AFsetHinfo p_((const char String[]));
void
AFsetNH p_((const char String[]));
void
AFwriteData p_((FILE *fp, float Fbuff[], int Nval));

/* ----- AR Prototypes ----- */
void
ARfZero p_((float x[], int N));
void
ARfShift p_((float x[], int Nkeep, int Nshift));
int
ARfSymArray p_((const float x[], int N));
void
ARiZero p_((int x[], int N));

/* ----- FI Prototypes ----- */
void
FIbiquad p_((const float x[], float y[], int Nout, const float h[]));
void
FIfiltIIR p_((const float x[], float y[], int Nout, const float h[][5],
	      int Nsec));
void
FIconvol p_((const float x[], float y[], int Nout, const float h[], int Ncof));
void
FIconvolSI p_((const float x[], float y[], int Nout, const float h[], int Ncof,
	       int mr, int Nsub, int Ir));
void
FIfiltAP p_((const float x[], float y[], int Nout, const float p[], int Np));
int
FIreadFilt p_((const char FiltFile[], int Maxcof, float h[], int *Ncof,
	       FILE *fpout));

/* ----- FL Prototypes ----- */
void
FLbackup p_((const char Fname[]));
void
FLbaseName p_((const char Fname[], char Bname[]));
void
FLdefName p_((const char Fi[], const char Fd[], char Fo[]));
void
FLdirName p_((const char Fname[], char Bname[]));
void
FLexpHome p_((const char Fname[], char Ename[]));
char *
FLfileDate p_((FILE *fp, int format));
void
FLfullName p_((const char Fname[], char Fullname[]));
void
FLhomeDir p_((const char User[], char Home[]));
void
FLpathList p_((const char Fi[], const char Dlist[], char Fo[]));

/* ----- MS Prototypes ----- */
int
MSiCeil p_((int n, int m));
int
MSiFloor p_((int n, int m));
double
MSdNint p_((double x));

/* ----- SP Prototypes ----- */
int
SPquant p_((const float *x, const float Xq[], int Nlev));

/* ----- ST Prototypes ----- */
void
STcatMax p_((const char Si[], char So[], size_t Maxchar));
void
STcopyMax p_((const char Si[], char So[], size_t Maxchar));
void
STcopyNMax p_((const char Si[], char So[], size_t N, size_t Maxchar));
int
STdecFloat1 p_((const char String[], float *Fval));
int
STdecFloats p_((const char String[], int Nmin, int Nmax, float Fval[],
		int *N));
int
STdecInt1 p_((const char String[], int *Ival));
int
STdecInts p_((const char String[], int Nmin, int Nmax, int Ival[],
	      int *N));
int
STdecRange p_((const char String[], int *Ival1, int *Ival2));
char *
STfindToken p_((const char String[], const char Delims[],
		const char Quotes[], char Token[], int WSFlag,
		int Maxchar));
int
STkeyMatch p_((const char String[], const char *KeyTable[]));

/* ----- UT Prototypes ----- */
char *
UTdate p_((int format));
void
UTerrorHalt p_((const char Errmsg[], ...));
void
UTfree p_((void *ptr));
int
UTgetOption p_((int *State, int argc, const char *argv[],
		const char *OptTable[], const char *OptArg[]));
char *
UTgetProg p_((void));
void *
UTmalloc p_((size_t size));
void
UTsetProg p_((const char Program[]));
void
UTsysErrHalt p_((const char Errmsg[], ...));
char *
UTuserName p_((void));
void
UTwarn p_((const char Warnmsg[], ...));

#endif /* __LIBTSP_H__ */
