/*------------- Telecommunications & Signal Processing Lab -------------
                           McGill University

Module:
void IAoptions (int argc, const char *argv[], char NHparms[], int *Bflag,
                char Fname[])

Purpose:
  Decode options for InfoAudio

Description:
  This routine decodes options for InfoAudio.

Parameters:
  ->  int
  argc -	Number of command line arguments
  ->  const char * []
  argv -	Pointer to argument strings
  <-  char [MXSTRING+1]
  NHparms -	Parameters for headerless input files, default ""
  <-  int *
  Bflag -	Flag to select less output, default 0
  <-  char [FILENAME_MAX+1]
  Fname -	File name

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/02/11 01:35:22 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: IAoptions.c 1.5 1994/02/11 AFsp-V1R2 $";

#include <stdlib.h>		/* prototype for exit */
#include <stdio.h>
#include <libtsp.h>
#include "InfoAudio.h"

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS	0	/* Normally in stdlib.h */
#endif

#define	NFILE		1
#define	NOPT	((sizeof OptTable / sizeof OptTable[0]) - 1)

/* Option tables and usage message */
static const char *nullTable[] = { NULL };
static const char *OptTable[] = {
  "-P**:", "--p*arameters=*",
  "-b", "--b*rief*",
  "-h", "--h*elp",
  "-v", "--v*ersion",
  "--",
  NULL
};
static const char Usage[] = "\
Usage: %s [options] AFile\n\
Options:\n\
  -P PARMS, --parameters=PARMS  Parameters for headerless input files.\n\
  -b, --brief,                  Print only the data format parameters.\n\
  -h, --help                    Print a list of options and exit.\n\
  -v, --version                 Print the version number and exit.";

void
IAoptions (argc, argv, NHparms, Bflag, Fname)

     int argc;
     const char *argv[];
     char NHparms[MXSTRING+1];
     int *Bflag;
     char Fname[FILENAME_MAX+1];

{
  int State;
  const char *OptArg;
  const char **optt;

  int n;
  int nF;
  int bflag;

/* Initialization */
  UTsetProg (PROGRAM);
  nF = 0;
  bflag = 0;

/* Decode options */
  State = 0;
  optt = OptTable;
  while (1) {
    n = UTgetOption (&State, argc, argv, optt, &OptArg);
    if (n == -1)
      break;
    switch (n) {
    case 0:
      /* Filename argument */
      ++nF;
      if (nF > NFILE)
	UTerrorHalt ("%s: Too many filenames specified", PROGRAM);
      STcopyMax (OptArg, Fname, FILENAME_MAX);
      break;
    case 1:
    case 2:
      /* Headerless input parameters */
      STcopyMax (OptArg, NHparms, MXSTRING);
      break;
    case 3:
    case 4:
      /* Brief flag */
      bflag = 1;
      break;
    case NOPT-4:
    case NOPT-3:
      /* Help */
      UTwarn (Usage, PROGRAM);
      exit (EXIT_SUCCESS);
      break;
    case NOPT-2:
    case NOPT-1:
      /* Version */
      printf ("%s: %s\n", PROGRAM, VERSION);
      exit (EXIT_SUCCESS);
      break;
    case NOPT:
      /* Stop interpreting options */
      optt = nullTable;
      break;
    default:
      /* Option error */
      UTerrorHalt (Usage, PROGRAM);
      break;
    }
  }

/* Error check */
  if (nF < NFILE)
    UTerrorHalt ("%s: Too few files specified", PROGRAM);

/* Return parameters */
  *Bflag = bflag;
}
