/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  FiltAudio.h

Description:
  Procedure prototypes for FiltAudio

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.6 $  $Date: 1994/02/13 16:05:16 $

----------------------------------------------------------------------*/

#ifndef __FILTAUDIO_H__
#define __FILTAUDIO_H__

#include <stdio.h>		/* typedef for FILE */

#define PROGRAM "FiltAudio"
#define VERSION	"V1R2  1994/02/13"

#define	MXINFO		1000
#define	MXSTRING	256
#define	MAXCOF		1000

#ifdef __STDC__
#	define p_(params)	params
#else
#	define p_(params)	()
#	/* Define const to be empty for K&R C */
#	define const
#endif

/* Prototypes */
void
FAfiltAP p_((FILE *fpI, FILE *fpO, long int NsampO, const float h[], int Ncof,
	     long int loffs));
void
FAfiltFIR p_((FILE *fpI, FILE *fpO, long int NsampO, const float h[], int Ncof,
	      long int loffs));
void
FAfiltIIR p_((FILE *fpI, FILE *fpO, long int NsampO, const float h[][5],
	      int Nsec, long int loffs));
void
FAfiltSI p_((FILE *fpI, FILE *fpO, long int NsampO, const float h[], int Ncof,
	     int Nsub, int Ir, long int moffs));
void
FAoptions p_((int argc, const char *argv[], int *FormatO, long int *Nout,
	      long int *idoffs, int *Nsub, int *Ir, char Hinfo[],
	      char NHparms[], char FiltFile[], char FnameI[], char FnameO[]));

#endif /* __FILTAUDIO_H__ */
