/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void CPdecChan (const char String, float Chgain[])

Purpose:
  Decode channel gain specifications

Description:
  This routine decodes gain factor strings.  The gain factor string takes the
  form
    [+/-] [gain *] chan +/- [gain *] chan ...)
  where chan is A through E.

Parameters:
  ->  const char []
  String -	Input string
  <-  float []
  Chgain -	Output vector of channel gains

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.4 $  $Date: 1994/02/04 15:49:54 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: CPdecChan.c 1.4 1994/02/04 AFsp-V1R2 $";

#include <string.h>
#include <libtsp.h>
#include "CopyAudio.h"

void
CPdecChan (String, Chgain)

     const char String[];
     float Chgain[];

{
  static char WS[] = " \t\n";
  int nc;
  const char *p;
  char *q;
  char *token;
  float sign;
  float nsign;
  float gain;
  char *Ch;
  int n;
  static const char *Chtab[] = { "A", "B", "C", "D", "E", NULL };

/* Allocate temporary space */
  nc = strlen (String);
  token = (char *) UTmalloc (nc + 1);

/* Loop over subexpressions */
  ARfZero (Chgain, MXCHAN);
  p = String;
  nsign = 1.;
  while (p != NULL) {

    /* Separate the string at + or - signs, p-1 points to the delimiter */
    p = STfindToken (p, "+-", "", token, 1, nc);

    /* Save the sign of the delimiter for the next iteration */
    sign = nsign;
    nsign = 1.;
    if (p != NULL && *(p-1) == '-')
      nsign = -1.;

    /* Special handling for a + or - followed by another + or - */
    if (token[0] == '\0') {
      nsign = sign * nsign;
      continue;
    }

    /* Pick up the gain value */
    q = strchr (token, '*');
    if (q != NULL) {
      *q = '\0';
      if (STdecFloat1 (token, &gain))
	UTerrorHalt ("CPdecChan: Invalid channel expression: \"%s\"", String);
      gain = sign * gain;
      Ch = q + 1;
    }
    else {
      gain = sign;
      Ch = token;
    }

    /* Remove leading whitespace from the channel designator */
    Ch = Ch + strspn (Ch, WS);

    /* Find the channel */
    n = STkeyMatch (Ch, Chtab);
    if (n < 0)
      UTerrorHalt ("CPdecChan: Invalid channel expression, \"%s\"", String);
    Chgain[n] = Chgain[n] + gain;
  }

  /* Deallocate the storage */
  UTfree (token);

}    
