/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void  CPcopySamp (FILE *fp[], long int Nchan[], int Nfiles, long int Lim[],
		    float Chgain[][])

Purpose:
  Copy audio file samples (linear combinations of values)

Description:
  This copies input audio file(s) to an output audio file.  The samples in the
  output file are linear combinations of the input channels.

Parameters:
  ->  FILE * []
  fp -		Array of Nfiles file pointers
  ->  long int []
  Nchan -	Array of Nfiles number of channels for each file
  ->  int
  Nfiles -	Number of files, Nfiles-1 input files and one output file
  ->  long int []
  Lim -		Two element array of sample limits
  ->  float [][]
  Chgain -	Array of channel gains

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/02/04 15:49:16 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: CPcopySamp.c 1.3 1994/02/04 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include "CopyAudio.h"

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define MAXV(a, b)	(((a) > (b)) ? (a) : (b))

#define	BFSIZE	5120

void  CPcopySamp (fp, Nchan, Nfiles, Lim, Chgain)

     FILE *fp[];
     long int Nchan[];
     int Nfiles;
     long int Lim[2];
     float Chgain[MXCHAN][MXCHAN];

{
  int Nifiles;
  long int NchanT;
  long int NchanMax;
  long int NchanO;
  long int offs;
  long int Nrec;
  int k;
  int n;
  int j;
  int l;
  int i;
  int p;
  int q;
  FILE *fpO;
  float Fbuf[BFSIZE];
  float *Fbufi;
  float *Fbufo;
  int Ns;
  float gain;

/* Initialization */
  if (Nfiles > MXFILE)
    UTerrorHalt ("CPcopySamp: Too many files");
  Nifiles = Nfiles - 1;
  NchanT = 0;
  NchanMax = 0;
  for (i = 0; i < Nifiles; ++i) {
    NchanMax = MAXV (NchanMax, Nchan[i]);
    NchanT = NchanT + Nchan[i];
  }
  if (NchanT > MXCHAN)
    UTerrorHalt ("CPcopySamp: Too many input channels");
  fpO = fp[Nfiles-1];
  NchanO = Nchan[Nfiles-1];

/*
   The copying operation takes scaled samples from the input si(n,i)
   (channel n, sample i) and sums them to form so(k,i) (channel k, sample i)

   so(k,i) = SUM g(k,n) * si(n,i)
              n
   However, samples from different channels are interleaved.  Thus so(k,i) is
   really so(i * No + k), where No is the number of output channels.  For the
   input data, the channels appear in different files.

   The copying operation loops over the input channels n, the samples i and the
   output channels k.  Here the inner loop is chosen to be over the samples,
   so that this loop can be skipped if the gain is zero.  This order also means
   that input files can be processed one-by-one.
*/

/* Divide the buffer space up */
  Ns = BFSIZE / (NchanMax + NchanO);
  Fbufi = Fbuf;
  Fbufo = Fbuf + NchanMax * Ns;

/* Main loop */
  offs = Lim[0];
  while (offs <= Lim[1]) {

    Nrec = MINV (Lim[1] - offs + 1, Ns);
    ARfZero (Fbufo, Nrec * NchanO);

    for (k = 0; k < NchanO; ++k) {
      n = 0;
      for (j = 0; j < Nifiles; ++j) {
	AFreadData (fp[j], offs * Nchan[j], Fbufi, Nrec * Nchan[j]);
	for (l = 0; l < Nchan[j]; ++l) {
	  gain = Chgain[k][n];
	  if (gain != 0.0) {
	    for (i = 0; i < Nrec; ++i) {
	      p = i * NchanO + k;
	      q = i * Nchan[j] + l;
	      Fbufo[p] += gain * Fbufi[q];
	    }
	  }
	  ++n;
	}
      }
    }
    /* Write the samples to the output file */
    AFwriteData (fpO, Fbufo, Nrec * NchanO);
    offs = offs + Nrec;
  }
}
