/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Module:
  CompAudio.h

Description:
  Procedure prototypes and structure definitions for CompAudio

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/02/13 16:03:41 $

----------------------------------------------------------------------*/

#ifndef __COMPAUDIO_H__
#define __COMPAUDIO_H__

#define PROGRAM "CompAudio"
#define VERSION	"V1R2  1994/02/13"

#define	MXSTRING	256

struct Stats_F {
  long int N;
  double Sx;
  double Sx2;
  float Vmin;
  float Vmax;
  long int Novload;
  long int Nrun;
  long int Nanomal;
  int Inrange;
};

struct Stats_T {
  double Sxy;
  long int Ndiff;
  float Diffmax;
  long int Nrun;
  long int Nseg;
  double SNRlog;
};

#include <stdio.h>		/* typedef for FILE */

#ifdef __STDC__
#	define p_(params)	params
#else
#	define p_(params)	()
#	/* Define const to be empty for K&R C */
#	define const
#endif

/* Prototypes */

void
CAcomp p_((FILE *fpA, FILE *fpB, long int Nsseg, int delayL, int delayU,
	   int *delayM, struct Stats_F *StatsA, struct Stats_F *StatsB,
	   struct Stats_T *StatsT));
void
CAcorr p_((FILE *fpA, FILE *fpB, int delay, long int Nsseg,
	   struct Stats_T *Stats));
void
CAoptions p_((int argc, const char *argv[], int *delayL, int *delayU,
	     char NHparms[], char FnameA[], char FnameB[]));
void
CAprcorr p_((struct Stats_F *StatsA, struct Stats_F *StatsB,
	     struct Stats_T *StatsT));
void
CAprstat p_((const struct Stats_F *Stats));
void
CAstats p_((FILE *fp, struct Stats_F *Stats));

#endif /* __COMPAUDIO_H__ */
