/*------------- Telecommunications & Signal Processing Lab --------------
                          McGill University
Module:
  void CAstats (FILE *fp, struct Stats_F *Stats)

Purpose:
  Gather statistics from an audio file

Description:
  This routine gathers statistics for an audio files.  The statistics are the
  sum of values, the sum of squared values, minimum value, and maximum value.
  In addition, the number overloads, number of overload runs, and number of
  anomalous transitions is returned.

Parameters:
  ->  FILE *
  fp -		File pointer
  <-  struct Stats_F *
  Stats -       Structure containing the file statistics

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/02/04 16:20:57 $

-----------------------------------------------------------------------*/

static char rcsid[] = "$Id: CAstats.c 1.3 1994/02/04 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>
#include "CompAudio.h"

#ifndef sun
#include <float.h>
#else
#include <values.h>
#define	FLT_MAX		MAXFLOAT
#endif

#define NBUF	2560
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define MAXV(a, b)	(((a) > (b)) ? (a) : (b))

void
CAstats (fp, Stats)

     FILE *fp;
     struct Stats_F *Stats;

{
  static const float Amax = 32767.;
  static const float Amin = -32768.;
  static const float Aup = 16383.;
  static const float Alw = -16384.;
  static struct Stats_F Init_F = {
    0, 0.0, 0.0, 0.0, 0.0, 0, 0, 0, 0};
  float X[NBUF];
  int Inrange;
  int i;
  long int ioffs;
  int N;
  double Sx;
  double Sx2;

/* Initialization */
  Init_F.Vmin = FLT_MAX;
  Init_F.Vmax = -FLT_MAX;
  *Stats = Init_F;
  Inrange = 0;

/* Read the audio files */
  ioffs = 0;

  while (1) {
    N = AFreadData (fp, ioffs, X, NBUF);
    if (N <= 0)
      break;
    Stats->N = Stats->N + N;
    ioffs = ioffs + NBUF;

/* Gather statistics */
    Sx = 0.0;
    Sx2 = 0.0;
    for (i = 0; i < N; ++i) {

      Stats->Vmax = MAXV (Stats->Vmax, X[i]);
      Stats->Vmin = MINV (Stats->Vmin, X[i]);

      /* Detect overloads and anomalous transitions */
      if (X[i] > Aup) {
	if (X[i] >= Amax) {
	  ++Stats->Novload;
	  if (Inrange != 2)
	    ++Stats->Nrun;
	  Inrange = 2;
	}
	else {
	  if (Inrange == -1)
	    ++Stats->Nanomal;
	  Inrange = 1;
	}
      }
      else if (X[i] < Alw) {
	if (X[i] <= Amin) {
	  ++Stats->Novload;
	  if (Inrange != -2)
	    ++Stats->Nrun;
	  Inrange = -2;
	}
	else {
	  if (Inrange == 1)
	    ++Stats->Nanomal;
	  Inrange = -1;
	}
      }
      else {
	Inrange = 0;
      }

/* Accumulate the double sums and sums of products */
      Sx = Sx + X[i];
      Sx2 = Sx2 + (double) X[i] * (double) X[i];
    }

/* Update the sum and sum of products */
    Stats->Sx = Stats->Sx + Sx;
    Stats->Sx2 = Stats->Sx2 + Sx2;
  }

}
