/*------------- Telecommunications & Signal Processing Lab --------------
                          McGill University
Module:
  void CAprstat (const struct Stats_F *Stats)

Purpose:
  Print statistics for an audio file

Description:
  This routine prints statistics for audio file data.  The standard information
  printed includes the mean, standard deviation, maximum value and minimum
  value.  For data which is restricted to the range [-32768,+32767], and the
  minimum and maximum values take on integer values, two  additional counts
  (if nonzero) are reported.  These are the number of overloads and the number
  of anomalous transitions.

Parameters:
  ->  const struct Stats_F *
  Stats -       Structure containing the file statistics

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/02/04 16:20:13 $

-----------------------------------------------------------------------*/

static char rcsid[] = "$Id: CAprstat.c 1.3 1994/02/04 AFsp-V1R2 $";

#include <math.h>		/* sqrt, modf */
#include "CompAudio.h"

#define MAXV(a, b)	(((a) > (b)) ? (a) : (b))

void
CAprstat (Stats)

     const struct Stats_F *Stats;

{
  static const float Amax = 32767.;
  static const float Amin = -32768.;
  double sd;
  double sm;
  double dint;
  int N;

  N = Stats->N;
  sd = sqrt ((Stats->Sx2 - (Stats->Sx * Stats->Sx) / N)/ MAXV (N-1, 1) );
  sm = Stats->Sx / N;
  printf ("    Std Dev = %-10.5g Mean = %-10.5g\n", sd, sm);
  printf ("    Max     = %-10.5g Min  = %-10.5g\n", Stats->Vmax, Stats->Vmin);

  if (Stats->Vmax <= Amax && Stats->Vmin >= Amin &&
      modf (Stats->Vmax, &dint) == 0.0 && modf (Stats->Vmin, &dint) == 0.0) {
    if (Stats->Novload > 0)
      printf ("    No. Overloads = %d (No. Runs = %d)\n", Stats->Novload,
	      Stats->Nrun);
    if (Stats->Nanomal > 0)
      printf ("    No. Anomalous Transitions = %d\n", Stats->Nanomal);
  }
}
